/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractTree;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={TreeProvider.class})
public class TreeProviderService
implements TreeProvider {
    @Override
    @NotNull
    public Tree createReadOnlyTree(@NotNull NodeState rootState) {
        return TreeFactory.createReadOnlyTree(rootState);
    }

    @Override
    @NotNull
    public Tree createReadOnlyTree(@NotNull Tree readOnlyParent, @NotNull String childName, @NotNull NodeState childState) {
        return TreeFactory.createReadOnlyTree(readOnlyParent, childName, childState);
    }

    @Override
    @NotNull
    public NodeState asNodeState(@NotNull Tree readOnlyTree) {
        Preconditions.checkArgument(readOnlyTree instanceof AbstractTree);
        return ((AbstractTree)readOnlyTree).getNodeState();
    }
}

