/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    @NotNull
    static String uuidFromNode(@NotNull NodeBuilder node) throws IllegalArgumentException {
        return Utils.uuidFromNode(node.getNodeState());
    }

    @NotNull
    static String uuidFromNode(@NotNull NodeState node) {
        PropertyState p = Preconditions.checkNotNull(node).getProperty("jcr:uuid");
        if (p == null) {
            throw new IllegalArgumentException("Not referenceable");
        }
        return p.getValue(Type.STRING);
    }

    @NotNull
    static String primaryTypeOf(@NotNull NodeBuilder node) throws IllegalStateException {
        String primaryType = Preconditions.checkNotNull(node).getName("jcr:primaryType");
        if (primaryType == null) {
            throw new IllegalStateException("Node does not have a jcr:primaryType");
        }
        return primaryType;
    }

    public static boolean isFrozenNodeReferenceable(@NotNull NodeState root) {
        return Utils.isFrozenNodeReferenceable(ReadOnlyNodeTypeManager.getInstance(RootFactory.createReadOnlyRoot(root), NamePathMapper.DEFAULT));
    }

    public static boolean isFrozenNodeReferenceable(@NotNull ReadOnlyNodeTypeManager ntMgr) {
        try {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = ntMgr.getNodeType("nt:frozenNode").getSupertypes()) {
                if (!superType.isNodeType("mix:referenceable")) continue;
                return true;
            }
        }
        catch (NoSuchNodeTypeException e) {
            LOG.info("Repository does not define nt:frozenNode. Assuming frozen nodes are not referenceable.");
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    static <T> T throwProtected(String path) throws CommitFailedException {
        throw new CommitFailedException("Constraint", 100, "Item is protected: " + path);
    }
}

