/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.Arrays;
import org.apache.jackrabbit.oak.api.StrictPathRestriction;
import org.apache.jackrabbit.oak.api.jmx.QueryEngineSettingsMBean;
import org.apache.jackrabbit.oak.query.QueryOptions;
import org.apache.jackrabbit.oak.query.QueryValidator;
import org.apache.jackrabbit.oak.query.stats.QueryStatsMBean;
import org.apache.jackrabbit.oak.query.stats.QueryStatsMBeanImpl;
import org.apache.jackrabbit.oak.query.stats.QueryStatsReporter;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryEngineSettings
implements QueryEngineSettingsMBean,
QueryLimits {
    public static final String SQL2_OPTIMISATION_FLAG = "oak.query.sql2optimisation";
    public static final String SQL2_OPTIMISATION_FLAG_2 = "oak.query.sql2optimisation2";
    public static final boolean SQL2_OPTIMIZATION_2 = Boolean.parseBoolean(System.getProperty("oak.query.sql2optimisation2", "true"));
    public static final String OAK_QUERY_LIMIT_IN_MEMORY = "oak.queryLimitInMemory";
    public static final long DEFAULT_QUERY_LIMIT_IN_MEMORY = Long.getLong("oak.queryLimitInMemory", 500000L);
    public static final String OAK_QUERY_LIMIT_READS = "oak.queryLimitReads";
    public static final long DEFAULT_QUERY_LIMIT_READS = Long.getLong("oak.queryLimitReads", 100000L);
    public static final String OAK_QUERY_PREFETCH_COUNT = "oak.prefetchCount";
    public static final String FT_NAME_PREFETCH_FOR_QUERIES = "FT_OAK-10490";
    public static final int DEFAULT_PREFETCH_COUNT = Integer.getInteger("oak.prefetchCount", -1);
    public static final String OAK_QUERY_FAIL_TRAVERSAL = "oak.queryFailTraversal";
    private static final boolean DEFAULT_FAIL_TRAVERSAL = Boolean.getBoolean("oak.queryFailTraversal");
    private static final boolean DEFAULT_FULL_TEXT_COMPARISON_WITHOUT_INDEX = Boolean.getBoolean("oak.queryFullTextComparisonWithoutIndex");
    private long limitInMemory = DEFAULT_QUERY_LIMIT_IN_MEMORY;
    private long limitReads = DEFAULT_QUERY_LIMIT_READS;
    private int prefetchCount = DEFAULT_PREFETCH_COUNT;
    private boolean failTraversal = DEFAULT_FAIL_TRAVERSAL;
    private boolean fullTextComparisonWithoutIndex = DEFAULT_FULL_TEXT_COMPARISON_WITHOUT_INDEX;
    private boolean sql2Optimisation = Boolean.parseBoolean(System.getProperty("oak.query.sql2optimisation", "true"));
    private static final String OAK_FAST_QUERY_SIZE = "oak.fastQuerySize";
    public static final boolean DEFAULT_FAST_QUERY_SIZE = Boolean.getBoolean("oak.fastQuerySize");
    private boolean fastQuerySize = DEFAULT_FAST_QUERY_SIZE;
    private StrictPathRestriction strictPathRestriction = StrictPathRestriction.DISABLE;
    private final QueryStatsMBeanImpl queryStats = new QueryStatsMBeanImpl(this);
    private final StatisticsProvider statisticsProvider;
    private final QueryValidator queryValidator = new QueryValidator();
    private String[] classNamesIgnoredInCallTrace = new String[0];
    private static final String OAK_QUERY_LENGTH_WARN_LIMIT = "oak.query.length.warn.limit";
    private static final String OAK_QUERY_LENGTH_ERROR_LIMIT = "oak.query.length.error.limit";
    private final long queryLengthWarnLimit = Long.getLong("oak.query.length.warn.limit", 0x100000L);
    private final long queryLengthErrorLimit = Long.getLong("oak.query.length.error.limit", 0x6400000L);
    private Feature prefetchFeature;
    private String autoOptionsMappingJson = "{}";
    private QueryOptions.AutomaticQueryOptionsMapping autoOptionsMapping = new QueryOptions.AutomaticQueryOptionsMapping(this.autoOptionsMappingJson);

    public long getQueryLengthWarnLimit() {
        return this.queryLengthWarnLimit;
    }

    public long getQueryLengthErrorLimit() {
        return this.queryLengthErrorLimit;
    }

    public QueryEngineSettings() {
        this.statisticsProvider = StatisticsProvider.NOOP;
    }

    public QueryEngineSettings(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    public void setPrefetchFeature(@Nullable Feature prefetch) {
        this.prefetchFeature = prefetch;
    }

    @Override
    public long getLimitInMemory() {
        return this.limitInMemory;
    }

    @Override
    public void setLimitInMemory(long limitInMemory) {
        this.limitInMemory = limitInMemory;
    }

    @Override
    public long getLimitReads() {
        return this.limitReads;
    }

    @Override
    public void setLimitReads(long limitReads) {
        this.limitReads = limitReads;
    }

    @Override
    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    @Override
    public int getPrefetchCount() {
        if (this.prefetchCount == -1) {
            return this.prefetchFeature != null && this.prefetchFeature.isEnabled() ? 20 : 0;
        }
        return this.prefetchCount;
    }

    @Override
    public void setAutoOptionsMappingJson(String json) {
        this.autoOptionsMappingJson = json;
        this.autoOptionsMapping = new QueryOptions.AutomaticQueryOptionsMapping(json);
    }

    @Override
    public String getAutoOptionsMappingJson() {
        return this.autoOptionsMappingJson;
    }

    public QueryOptions.AutomaticQueryOptionsMapping getAutomaticQueryOptions() {
        return this.autoOptionsMapping;
    }

    @Override
    public boolean getFailTraversal() {
        return this.failTraversal;
    }

    @Override
    public void setFailTraversal(boolean failTraversal) {
        this.failTraversal = failTraversal;
    }

    @Override
    public boolean isFastQuerySize() {
        return this.fastQuerySize;
    }

    @Override
    public void setFastQuerySize(boolean fastQuerySize) {
        this.fastQuerySize = fastQuerySize;
        System.setProperty(OAK_FAST_QUERY_SIZE, String.valueOf(fastQuerySize));
    }

    @Override
    public String getStrictPathRestriction() {
        return this.strictPathRestriction.name();
    }

    @Override
    public void setStrictPathRestriction(String strictPathRestriction) {
        this.strictPathRestriction = StrictPathRestriction.stringToEnum(strictPathRestriction);
    }

    public void setFullTextComparisonWithoutIndex(boolean fullTextComparisonWithoutIndex) {
        this.fullTextComparisonWithoutIndex = fullTextComparisonWithoutIndex;
    }

    @Override
    public boolean getFullTextComparisonWithoutIndex() {
        return this.fullTextComparisonWithoutIndex;
    }

    public boolean isSql2Optimisation() {
        return this.sql2Optimisation;
    }

    public QueryStatsMBean getQueryStats() {
        return this.queryStats;
    }

    public QueryStatsReporter getQueryStatsReporter() {
        return this.queryStats;
    }

    public StatisticsProvider getStatisticsProvider() {
        return this.statisticsProvider;
    }

    @Override
    public void setQueryValidatorPattern(String key, String pattern, String comment, boolean failQuery) {
        this.queryValidator.setPattern(key, pattern, comment, failQuery);
    }

    @Override
    public String getQueryValidatorJson() {
        return this.queryValidator.getJson();
    }

    public QueryValidator getQueryValidator() {
        return this.queryValidator;
    }

    @Override
    public void setIgnoredClassNamesInCallTrace(@NotNull String[] packageNames) {
        this.classNamesIgnoredInCallTrace = packageNames;
    }

    @Override
    @NotNull
    public String[] getIgnoredClassNamesInCallTrace() {
        return this.classNamesIgnoredInCallTrace;
    }

    public String toString() {
        return "QueryEngineSettings{limitInMemory=" + this.limitInMemory + ", limitReads=" + this.limitReads + ", failTraversal=" + this.failTraversal + ", fullTextComparisonWithoutIndex=" + this.fullTextComparisonWithoutIndex + ", sql2Optimisation=" + this.sql2Optimisation + ", fastQuerySize=" + this.fastQuerySize + ", prefetchCount=" + this.prefetchCount + ", classNamesIgnoredInCallTrace=" + Arrays.toString(this.classNamesIgnoredInCallTrace) + "}";
    }
}

