/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;

public class EquiJoinConditionImpl
extends JoinConditionImpl {
    private final String property1Name;
    private final String property2Name;
    private final String selector1Name;
    private final String selector2Name;
    private SelectorImpl selector1;
    private SelectorImpl selector2;

    public EquiJoinConditionImpl(String selector1Name, String property1Name, String selector2Name, String property2Name) {
        this.selector1Name = selector1Name;
        this.property1Name = property1Name;
        this.selector2Name = selector2Name;
        this.property2Name = property2Name;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.quote(this.selector1Name) + "." + this.quote(this.property1Name) + " = " + this.quote(this.selector2Name) + "." + this.quote(this.property2Name);
    }

    public void bindSelector(SourceImpl source) {
        this.selector1 = source.getExistingSelector(this.selector1Name);
        this.selector2 = source.getExistingSelector(this.selector2Name);
    }

    @Override
    public boolean evaluate() {
        PropertyValue p1 = this.selector1.currentProperty(this.property1Name);
        if (p1 == null) {
            return false;
        }
        PropertyValue p2 = this.selector2.currentProperty(this.property2Name);
        if (p2 == null) {
            return false;
        }
        if (!p1.isArray() && !p2.isArray()) {
            p2 = this.convertValueToType(p2, p1);
            return PropertyValues.match(p1, p2);
        }
        if (!p1.isArray() && p2.isArray()) {
            return (p1 = this.convertValueToType(p1, p2)) != null && PropertyValues.match(p1, p2);
        }
        if (p1.isArray() && !p2.isArray()) {
            return (p2 = this.convertValueToType(p2, p1)) != null && PropertyValues.match(p1, p2);
        }
        return PropertyValues.match(p1, p2);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.selector1)) {
            PropertyValue p2 = this.selector2.currentProperty(this.property2Name);
            if (p2 == null && f.isPreparing() && f.isPrepared(this.selector2)) {
                p2 = PropertyValues.newString("valueFromTheJoinSelector");
            }
            if (p2 != null && p2.isArray()) {
                p2 = null;
            }
            String p1n = this.normalizePropertyName(this.property1Name);
            if (p2 == null) {
                f.restrictProperty(p1n, Operator.NOT_EQUAL, null);
            } else {
                f.restrictProperty(p1n, Operator.EQUAL, p2);
            }
        }
        if (f.getSelector().equals(this.selector2)) {
            PropertyValue p1 = this.selector1.currentProperty(this.property1Name);
            if (p1 == null && f.isPreparing() && f.isPrepared(this.selector1)) {
                p1 = PropertyValues.newString("valueFromTheJoinSelector");
            }
            if (p1 != null && p1.isArray()) {
                p1 = null;
            }
            String p2n = this.normalizePropertyName(this.property2Name);
            f.restrictProperty(p2n, Operator.EQUAL, p1);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector1)) {
            PropertyExistenceImpl ex = new PropertyExistenceImpl(s.getSelectorName(), this.property1Name);
            ex.bindSelector(s);
            s.restrictSelector(ex);
        } else if (s.equals(this.selector2)) {
            PropertyExistenceImpl ex = new PropertyExistenceImpl(s.getSelectorName(), this.property2Name);
            ex.bindSelector(s);
            s.restrictSelector(ex);
        }
    }

    @Override
    public boolean isParent(SourceImpl source) {
        return false;
    }

    @Override
    public boolean canEvaluate(Set<SourceImpl> available) {
        return available.contains(this.selector1) && available.contains(this.selector2);
    }

    @Override
    public AstElement copyOf() {
        return new EquiJoinConditionImpl(this.selector1Name, this.property1Name, this.selector2Name, this.property2Name);
    }
}

