/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class FullTextSearchScoreImpl
extends DynamicOperandImpl {
    private final String selectorName;
    private SelectorImpl selector;

    public FullTextSearchScoreImpl(String selectorName) {
        this.selectorName = selectorName;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "score(" + this.quote(this.selectorName) + ")";
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        return null;
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public PropertyValue currentProperty() {
        PropertyValue p = this.selector.currentOakProperty("jcr:score");
        if (p == null) {
            return PropertyValues.newDouble(0.0);
        }
        return p;
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        if (f.getSelector().equals(this.selector)) {
            if (operator == Operator.NOT_EQUAL && v != null) {
                return;
            }
            f.restrictProperty("jcr:score", operator, v);
        }
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
    }

    @Override
    public String getFunction(SelectorImpl s) {
        return null;
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return s.equals(this.selector);
    }

    @Override
    int getPropertyType() {
        return 4;
    }

    @Override
    public DynamicOperandImpl createCopy() {
        return new FullTextSearchScoreImpl(this.selectorName);
    }

    @Override
    public QueryIndex.OrderEntry getOrderEntry(SelectorImpl s, OrderingImpl o) {
        return null;
    }

    @Override
    public String getOrderEntryPropertyName(SelectorImpl s) {
        return null;
    }
}

