/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.JcrNameParser;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.NodeLocalNameImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.util.ISO9075;

public class NodeNameImpl
extends DynamicOperandImpl {
    private final String selectorName;
    private SelectorImpl selector;

    public NodeNameImpl(String selectorName) {
        this.selectorName = selectorName;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "name(" + this.quote(this.selectorName) + ")";
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public boolean supportsRangeConditions() {
        return false;
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        return null;
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public PropertyValue currentProperty() {
        String path = this.selector.currentPath();
        if (path == null) {
            return null;
        }
        String name = PathUtils.getName(path);
        return PropertyValues.newName(name);
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        if (v == null) {
            return;
        }
        if (operator == Operator.NOT_EQUAL) {
            return;
        }
        String name = NodeNameImpl.getName(this.query, v);
        if (name != null && f.getSelector().equals(this.selector)) {
            if (NodeNameImpl.supportedOperator(operator)) {
                String localName = NodeLocalNameImpl.getLocalName(name);
                f.restrictProperty(":localname", operator, PropertyValues.newString(localName));
            }
            String fn = this.getFunction(f.getSelector());
            f.restrictProperty("function*" + fn, operator, v, 1);
        }
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
    }

    @Override
    public String getFunction(SelectorImpl s) {
        if (!s.equals(this.selector)) {
            return null;
        }
        return "@:name";
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return s.equals(this.selector);
    }

    static String getName(QueryImpl query, PropertyValue v) {
        switch (v.getType().tag()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return null;
            }
        }
        String name = v.getValue(Type.NAME);
        name = ISO9075.decode(name);
        if (query.getNamePathMapper() != null) {
            String mappedName = query.getNamePathMapper().getOakPath(name);
            if (mappedName == null) {
                throw new IllegalArgumentException("Not a valid JCR name: " + name);
            }
            name = mappedName;
        }
        if (PathUtils.isAbsolute(name)) {
            throw new IllegalArgumentException("Not a valid JCR name: " + name + " (absolute paths are not names)");
        }
        if (PathUtils.getDepth(name) > 1) {
            throw new IllegalArgumentException("Not a valid JCR name: " + name + " (relative path with depth > 1 are not names)");
        }
        if (name.startsWith("[") && !name.endsWith("]")) {
            return null;
        }
        if (!JcrNameParser.validate(name)) {
            return null;
        }
        return name;
    }

    static boolean supportedOperator(Operator o) {
        return o == Operator.EQUAL || o == Operator.LIKE;
    }

    @Override
    int getPropertyType() {
        return 7;
    }

    @Override
    public DynamicOperandImpl createCopy() {
        return new NodeNameImpl(this.selectorName);
    }

    @Override
    public QueryIndex.OrderEntry getOrderEntry(SelectorImpl s, OrderingImpl o) {
        if (!s.equals(this.selector)) {
            return null;
        }
        return new QueryIndex.OrderEntry("function*" + this.getFunction(s), Type.STRING, o.isDescending() ? QueryIndex.OrderEntry.Order.DESCENDING : QueryIndex.OrderEntry.Order.ASCENDING);
    }
}

