/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.authorization.AuthorizationContext;
import org.apache.jackrabbit.oak.security.authorization.AuthorizationInitializer;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlImporter;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlManagerImpl;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlValidatorProvider;
import org.apache.jackrabbit.oak.security.authorization.monitor.AuthorizationMonitor;
import org.apache.jackrabbit.oak.security.authorization.monitor.AuthorizationMonitorImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.AllPermissionProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.MountPermissionProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionHook;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStoreValidatorProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidatorProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.VersionablePathHook;
import org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.apache.jackrabbit.oak.stats.Monitor;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Component(service={AuthorizationConfiguration.class, SecurityConfiguration.class}, property={"oak.security.name=org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl"})
@Designate(ocd=Configuration.class)
public class AuthorizationConfigurationImpl
extends ConfigurationBase
implements AuthorizationConfiguration,
ProviderCtx {
    private MountInfoProvider mountInfoProvider = Mounts.defaultMountInfoProvider();
    private AuthorizationMonitor monitor = new AuthorizationMonitorImpl(StatisticsProvider.NOOP);

    public AuthorizationConfigurationImpl() {
    }

    public AuthorizationConfigurationImpl(@NotNull SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authorization"));
    }

    @Activate
    private void activate(Configuration configuration, Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Override
    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.authorization";
    }

    @Override
    @NotNull
    public WorkspaceInitializer getWorkspaceInitializer() {
        return new AuthorizationInitializer(this.mountInfoProvider);
    }

    @Override
    @NotNull
    public List<? extends CommitHook> getCommitHooks(@NotNull String workspaceName) {
        return ImmutableList.of(new VersionablePathHook(workspaceName, this), new PermissionHook(workspaceName, this.getRestrictionProvider(), this));
    }

    @NotNull
    public List<ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        return ImmutableList.of(new PermissionStoreValidatorProvider(), new PermissionValidatorProvider(workspaceName, principals, moveTracker, this), new AccessControlValidatorProvider(this));
    }

    @Override
    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return ImmutableList.of(new AccessControlImporter());
    }

    @Override
    @NotNull
    public Context getContext() {
        return AuthorizationContext.getInstance();
    }

    @Override
    @NotNull
    public Iterable<Monitor<?>> getMonitors(@NotNull StatisticsProvider statisticsProvider) {
        this.monitor = new AuthorizationMonitorImpl(statisticsProvider);
        return Collections.singleton(this.monitor);
    }

    @Override
    @NotNull
    public AccessControlManager getAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        return new AccessControlManagerImpl(root, namePathMapper, this.getSecurityProvider());
    }

    @Override
    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        RestrictionProvider restrictionProvider = this.getParameters().getConfigValue("restrictionProvider", null, RestrictionProvider.class);
        if (restrictionProvider == null) {
            restrictionProvider = new RestrictionProviderImpl();
        }
        return restrictionProvider;
    }

    @Override
    @NotNull
    public PermissionProvider getPermissionProvider(@NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals) {
        Context ctx = this.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class).getContext();
        if (PermissionUtil.isAdminOrSystem(principals, this.getParameters())) {
            return new AllPermissionProviderImpl(root, this);
        }
        if (this.mountInfoProvider.hasNonDefaultMounts()) {
            return new MountPermissionProvider(root, workspaceName, principals, this.getRestrictionProvider(), this.getParameters(), ctx, this);
        }
        return new PermissionProviderImpl(root, workspaceName, principals, this.getRestrictionProvider(), this.getParameters(), ctx, this);
    }

    @Override
    @NotNull
    public MountInfoProvider getMountInfoProvider() {
        return this.mountInfoProvider;
    }

    @Override
    @NotNull
    public AuthorizationMonitor getMonitor() {
        return this.monitor;
    }

    @Reference(name="mountInfoProvider", cardinality=ReferenceCardinality.MANDATORY)
    public void bindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    public void unbindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = null;
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak AuthorizationConfiguration")
    static @interface Configuration {
        @AttributeDefinition(name="Jackrabbit 2.x Permissions", description="Enforce backwards compatible permission validation with respect to the configurable options.", cardinality=2, options={@Option(label="USER_MANAGEMENT", value="USER_MANAGEMENT"), @Option(label="REMOVE_NODE", value="REMOVE_NODE")})
        public String permissionsJr2();

        @AttributeDefinition(name="Import Behavior", description="Behavior for access control related items upon XML import.", options={@Option(label="abort", value="abort"), @Option(label="besteffort", value="besteffort"), @Option(label="ignore", value="ignore")})
        public String importBehavior() default "abort";

        @AttributeDefinition(name="Readable Paths", description="Enable full read access to regular nodes and properties at the specified paths irrespective of other policies that may take effective.")
        public String[] readPaths() default {"/jcr:system/rep:namespaces", "/jcr:system/jcr:nodeTypes", "/jcr:system/rep:privileges"};

        @AttributeDefinition(name="Administrative Principals", description="Allows to specify principals that should be granted full permissions on the complete repository content.", cardinality=10)
        public String[] administrativePrincipals();

        @AttributeDefinition(name="Ranking", description="Ranking of this configuration in a setup with multiple authorization configurations.")
        public int configurationRanking() default 100;
    }
}

