/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization;

import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.security.authorization.permission.MountPermissionProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;

class AuthorizationInitializer
implements WorkspaceInitializer,
AccessControlConstants,
PermissionConstants {
    private final MountInfoProvider mountInfoProvider;

    AuthorizationInitializer(@NotNull MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    @Override
    public void initialize(NodeBuilder builder, String workspaceName) {
        NodeBuilder permissionStore;
        NodeBuilder index = IndexUtils.getOrCreateOakIndex(builder);
        if (!index.hasChildNode("acPrincipalName")) {
            NodeBuilder acPrincipalName = IndexUtils.createIndexDefinition(index, "acPrincipalName", true, false, ImmutableList.of("rep:principalName"), ImmutableList.of("rep:DenyACE", "rep:GrantACE", "rep:ACE"));
            acPrincipalName.setProperty("info", "Oak index used by authorization to quickly search a principal by name.");
        }
        if (!(permissionStore = builder.child("jcr:system").child("rep:permissionStore")).hasProperty("jcr:primaryType")) {
            permissionStore.setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
        }
        if (!permissionStore.hasChildNode(workspaceName)) {
            permissionStore.child(workspaceName).setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
        }
        for (Mount m : this.mountInfoProvider.getNonDefaultMounts()) {
            String permissionRootName = MountPermissionProvider.getPermissionRootName(m, workspaceName);
            if (permissionStore.hasChildNode(permissionRootName)) continue;
            permissionStore.child(permissionRootName).setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
        }
    }
}

