/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Objects;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.jetbrains.annotations.NotNull;

public class ValidationEntry {
    protected final String principalName;
    protected final PrivilegeBits privilegeBits;
    protected final boolean isAllow;
    protected final Set<Restriction> restrictions;
    protected final int index;

    public ValidationEntry(@NotNull String principalName, @NotNull PrivilegeBits privilegeBits, boolean isAllow, @NotNull Set<Restriction> restrictions) {
        this.principalName = principalName;
        this.privilegeBits = privilegeBits;
        this.isAllow = isAllow;
        this.restrictions = restrictions;
        this.index = -1;
    }

    public ValidationEntry(@NotNull String principalName, @NotNull PrivilegeBits privilegeBits, boolean isAllow, @NotNull Set<Restriction> restrictions, int index) {
        this.principalName = principalName;
        this.privilegeBits = privilegeBits;
        this.isAllow = isAllow;
        this.restrictions = restrictions;
        this.index = index;
    }

    public int hashCode() {
        return Objects.hashCode(this.principalName, this.privilegeBits, this.restrictions, this.isAllow);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ValidationEntry) {
            ValidationEntry other = (ValidationEntry)o;
            return this.isAllow == other.isAllow && Objects.equal(this.principalName, other.principalName) && this.privilegeBits.equals(other.privilegeBits) && this.restrictions.equals(other.restrictions);
        }
        return false;
    }
}

