/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.guava.common.collect.ImmutableCollection;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregationFilter;
import org.jetbrains.annotations.NotNull;

class CompositeAccessControlManager
extends AbstractAccessControlManager {
    private final List<AccessControlManager> acMgrs;
    private final AggregationFilter aggregationFilter;

    public CompositeAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper, @NotNull SecurityProvider securityProvider, @NotNull List<AccessControlManager> acMgrs, @NotNull AggregationFilter aggregationFilter) {
        super(root, namePathMapper, securityProvider);
        this.acMgrs = acMgrs;
        this.aggregationFilter = aggregationFilter;
    }

    @Override
    @NotNull
    public Privilege[] getSupportedPrivileges(String absPath) throws RepositoryException {
        ImmutableSet.Builder privs = ImmutableSet.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            privs.add(acMgr.getSupportedPrivileges(absPath));
        }
        ImmutableCollection s = privs.build();
        return s.toArray(new Privilege[0]);
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            policies.add(acMgr.getPolicies(absPath));
        }
        ImmutableCollection l = policies.build();
        return l.toArray(new AccessControlPolicy[0]);
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            policies.add(acMgr.getEffectivePolicies(absPath));
            if (!this.aggregationFilter.stop(acMgr, absPath)) continue;
            break;
        }
        return (AccessControlPolicy[])policies.build().stream().distinct().toArray(AccessControlPolicy[]::new);
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        ArrayList<AccessControlPolicyIterator> l = Lists.newArrayList();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner)) continue;
            l.add(acMgr.getApplicablePolicies(absPath));
        }
        return new AccessControlPolicyIteratorAdapter(Iterators.concat((Iterator[])l.toArray(new AccessControlPolicyIterator[0])));
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)acMgr).defines(absPath, policy)) continue;
            acMgr.setPolicy(absPath, policy);
            return;
        }
        throw new AccessControlException("Cannot set access control policy " + policy + "; no PolicyOwner found.");
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)acMgr).defines(absPath, policy)) continue;
            acMgr.removePolicy(absPath, policy);
            return;
        }
        throw new AccessControlException("Cannot remove access control policy " + policy + "; no PolicyOwner found.");
    }

    @Override
    @NotNull
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(@NotNull Principal principal) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager) || !(acMgr instanceof PolicyOwner)) continue;
            policies.add(((JackrabbitAccessControlManager)acMgr).getApplicablePolicies(principal));
        }
        ImmutableCollection l = policies.build();
        return l.toArray(new JackrabbitAccessControlPolicy[0]);
    }

    @Override
    @NotNull
    public JackrabbitAccessControlPolicy[] getPolicies(@NotNull Principal principal) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            policies.add(((JackrabbitAccessControlManager)acMgr).getPolicies(principal));
        }
        ImmutableCollection l = policies.build();
        return l.toArray(new JackrabbitAccessControlPolicy[0]);
    }

    @Override
    @NotNull
    public AccessControlPolicy[] getEffectivePolicies(@NotNull Set<Principal> principals) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            JackrabbitAccessControlManager jAcMgr = (JackrabbitAccessControlManager)acMgr;
            policies.add(jAcMgr.getEffectivePolicies(principals));
            if (!this.aggregationFilter.stop(jAcMgr, principals)) continue;
            break;
        }
        ImmutableCollection l = policies.build();
        return l.toArray(new AccessControlPolicy[0]);
    }

    @Override
    @NotNull
    public Iterator<AccessControlPolicy> getEffectivePolicies(@NotNull Set<Principal> principals, String ... absPaths) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        ImmutableList.Builder iterators = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            JackrabbitAccessControlManager jAcMgr = (JackrabbitAccessControlManager)acMgr;
            iterators.add(jAcMgr.getEffectivePolicies(principals, absPaths));
            if (!this.aggregationFilter.stop(jAcMgr, principals)) continue;
            break;
        }
        return Iterators.concat(iterators.build().toArray(new Iterator[0]));
    }
}

