/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Objects;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CurrentPattern
implements RestrictionPattern {
    private static final Set<String> PREFIXES = ImmutableSet.of("oak", "rep", "jcr");
    private static final Set<String> NODE_NAMES = ((ImmutableSet.Builder)ImmutableSet.builder().add(new String[]{"jcr:childNodeDefinition", "jcr:content", "jcr:frozenNode", "jcr:propertyDefinition", "jcr:rootVersion", "jcr:system", "jcr:versionLabels", "jcr:versionStorage", "jcr:nodeTypes", "rep:namedChildNodeDefinitions", "rep:residualChildNodeDefinitions", "rep:namedPropertyDefinitions", "rep:residualPropertyDefinitions", "rep:ours", "jcr:activities", "jcr:configurations", "rep:policy", "rep:repoPolicy", "rep:restrictions", "rep:pwd", "rep:membersList", "oak:index", "rep:cugPolicy", "rep:principalPolicy"})).build();
    private final String treePath;
    private final Set<String> propertyNames;

    CurrentPattern(@NotNull String treePath, @NotNull Iterable<String> propertyNames) {
        this.treePath = treePath;
        this.propertyNames = ImmutableSet.copyOf(propertyNames);
    }

    @Override
    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        String propName = property == null ? null : property.getName();
        return this.matches(tree.getPath(), propName);
    }

    @Override
    public boolean matches(@NotNull String path) {
        String propName = CurrentPattern.getPropertyNameOrNull(path);
        String nodePath = propName == null ? path : PathUtils.getParentPath(path);
        return this.matches(nodePath, propName);
    }

    @Override
    public boolean matches(@NotNull String path, boolean isProperty) {
        if (isProperty) {
            if (PathUtils.denotesRoot(path)) {
                return false;
            }
            return this.matches(PathUtils.getParentPath(path), PathUtils.getName(path));
        }
        return this.matches(path, null);
    }

    @Override
    public boolean matches() {
        return false;
    }

    private boolean matches(@NotNull String nodePath, @Nullable String propertyName) {
        if (!this.treePath.equals(nodePath)) {
            return false;
        }
        if (propertyName == null) {
            return true;
        }
        if (this.propertyNames.isEmpty()) {
            return false;
        }
        if (this.propertyNames.contains("*")) {
            return true;
        }
        return this.propertyNames.contains(propertyName);
    }

    @Nullable
    private static String getPropertyNameOrNull(@NotNull String path) {
        if (PathUtils.denotesRoot(path)) {
            return null;
        }
        String name = PathUtils.getName(path);
        String prefix = Text.getNamespacePrefix(name);
        if (PREFIXES.contains(prefix) && !NODE_NAMES.contains(name)) {
            return name;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hashCode(this.treePath, this.propertyNames);
    }

    public String toString() {
        return this.treePath + " : " + this.propertyNames;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CurrentPattern) {
            CurrentPattern other = (CurrentPattern)obj;
            return this.treePath.equals(other.treePath) && this.propertyNames.equals(other.propertyNames);
        }
        return false;
    }
}

