/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.privilege.ImmutablePrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.jetbrains.annotations.NotNull;

class PrivilegeDefinitionWriter
implements PrivilegeConstants {
    private final Root root;
    private final PrivilegeBitsProvider bitsMgr;
    private PrivilegeBits next;

    PrivilegeDefinitionWriter(@NotNull Root root) {
        this.root = root;
        this.bitsMgr = new PrivilegeBitsProvider(root);
        Tree privilegesTree = this.bitsMgr.getPrivilegesTree();
        this.next = privilegesTree.exists() && privilegesTree.hasProperty("rep:next") ? PrivilegeBits.getInstance(privilegesTree) : PrivilegeBits.NEXT_AFTER_BUILT_INS;
    }

    void writeDefinition(@NotNull PrivilegeDefinition definition) throws RepositoryException {
        this.writeDefinitions(Collections.singleton(definition));
    }

    void writeBuiltInDefinitions() throws RepositoryException {
        this.writeDefinitions(PrivilegeDefinitionWriter.getBuiltInDefinitions());
    }

    @NotNull
    private PrivilegeBits getNext() {
        return this.next;
    }

    @NotNull
    private PrivilegeBits next() {
        PrivilegeBits bits = this.next;
        this.next = bits.nextBits();
        return bits;
    }

    private void writeDefinitions(@NotNull Iterable<PrivilegeDefinition> definitions) throws RepositoryException {
        try {
            Tree privilegesTree = this.root.getTree("/jcr:system/rep:privileges");
            if (!privilegesTree.exists()) {
                throw new RepositoryException("Privilege store does not exist.");
            }
            for (PrivilegeDefinition definition : definitions) {
                if (privilegesTree.hasChild(definition.getName())) {
                    throw new RepositoryException("Privilege definition with name '" + definition.getName() + "' already exists.");
                }
                this.writePrivilegeNode(privilegesTree, definition);
            }
            this.getNext().writeTo(privilegesTree);
            this.root.commit();
        }
        catch (CommitFailedException e) {
            throw e.asRepositoryException();
        }
    }

    private void writePrivilegeNode(@NotNull Tree privilegesTree, @NotNull PrivilegeDefinition definition) throws RepositoryException {
        PrivilegeBits bits;
        Set<String> declAggrNames;
        boolean isAggregate;
        String name = definition.getName();
        Tree privilegeNode = TreeUtil.addChild(privilegesTree, name, "rep:Privilege");
        if (definition.isAbstract()) {
            privilegeNode.setProperty("rep:isAbstract", true);
        }
        boolean bl = isAggregate = !(declAggrNames = definition.getDeclaredAggregateNames()).isEmpty();
        if (isAggregate) {
            privilegeNode.setProperty("rep:aggregates", declAggrNames, Type.NAMES);
        }
        if (PrivilegeBits.BUILT_IN.containsKey(name)) {
            bits = PrivilegeBits.BUILT_IN.get(name);
        } else if (isAggregate) {
            bits = this.bitsMgr.getBits(declAggrNames);
            if (bits.isEmpty()) {
                throw new RepositoryException("Illegal aggregation of non-existing privileges on '" + name + "'.");
            }
        } else {
            bits = this.next();
        }
        bits.writeTo(privilegeNode);
    }

    @NotNull
    private static Collection<PrivilegeDefinition> getBuiltInDefinitions() {
        LinkedHashMap<String, ImmutablePrivilegeDefinition> definitions = new LinkedHashMap<String, ImmutablePrivilegeDefinition>();
        NON_AGGREGATE_PRIVILEGES.forEach(privilegeName -> {
            ImmutablePrivilegeDefinition def = new ImmutablePrivilegeDefinition((String)privilegeName, false, null);
            definitions.put((String)privilegeName, def);
        });
        AGGREGATE_PRIVILEGES.forEach((privilegeName, aggregatedNames) -> {
            ImmutablePrivilegeDefinition def = new ImmutablePrivilegeDefinition((String)privilegeName, false, (Iterable<String>)Arrays.asList(aggregatedNames));
            definitions.put((String)privilegeName, def);
        });
        ImmutablePrivilegeDefinition all = new ImmutablePrivilegeDefinition("jcr:all", false, definitions.keySet());
        definitions.put("jcr:all", all);
        return definitions.values();
    }
}

