/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.text.Normalizer;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AuthorizableBaseProvider
implements UserConstants {
    final ConfigurationParameters config;
    final Root root;
    final IdentifierManager identifierManager;
    private final boolean usercaseMappedProfile;

    AuthorizableBaseProvider(@NotNull Root root, @NotNull ConfigurationParameters config) {
        this.root = Preconditions.checkNotNull(root);
        this.config = Preconditions.checkNotNull(config);
        this.identifierManager = new IdentifierManager(root);
        this.usercaseMappedProfile = config.getConfigValue("enableRFC7613UsercaseMappedProfile", false);
    }

    @Nullable
    Tree getByID(@NotNull String authorizableId, @NotNull AuthorizableType authorizableType) {
        return this.getByContentID(this.getContentID(authorizableId), authorizableType);
    }

    @Nullable
    private Tree getByContentID(@NotNull String contentId, @NotNull AuthorizableType authorizableType) {
        Tree tree = this.identifierManager.getTree(contentId);
        if (UserUtil.isType(tree, authorizableType)) {
            return tree;
        }
        return null;
    }

    @Nullable
    Tree getByPath(@NotNull String authorizableOakPath, @NotNull AuthorizableType type) {
        Tree tree = this.root.getTree(authorizableOakPath);
        if (UserUtil.isType(tree, type)) {
            return tree;
        }
        return null;
    }

    @NotNull
    String getContentID(@NotNull Tree authorizableTree) {
        return IdentifierManager.getIdentifier(authorizableTree);
    }

    @NotNull
    String getContentID(@NotNull String authorizableId) {
        String s = authorizableId.toLowerCase();
        if (this.usercaseMappedProfile) {
            s = Normalizer.normalize(s, Normalizer.Form.NFKC);
        }
        return UUIDUtils.generateUUID(s);
    }
}

