/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuthorizableIterator
implements Iterator<Authorizable> {
    private static final Logger log = LoggerFactory.getLogger(AuthorizableIterator.class);
    private final Iterator<? extends Authorizable> authorizables;
    private final long size;
    private final Set<String> servedIds;

    @NotNull
    static AuthorizableIterator create(@NotNull Iterator<Tree> authorizableTrees, @NotNull UserManagerImpl userManager, @NotNull AuthorizableType authorizableType) {
        Iterator<Authorizable> it = Iterators.transform(authorizableTrees, new TreeToAuthorizable(userManager, authorizableType));
        long size = AuthorizableIterator.getSize(authorizableTrees);
        return new AuthorizableIterator(it, size, false);
    }

    @NotNull
    static AuthorizableIterator create(boolean filterDuplicates, @NotNull Iterator<? extends Authorizable> it1) {
        long size = AuthorizableIterator.getSize(it1);
        return new AuthorizableIterator(it1, size, filterDuplicates);
    }

    @NotNull
    static AuthorizableIterator create(boolean filterDuplicates, @NotNull Iterator<? extends Authorizable> it1, @NotNull Iterator<? extends Authorizable> it2) {
        long size = 0L;
        for (Iterator it : new Iterator[]{it1, it2}) {
            long l = AuthorizableIterator.getSize(it);
            if (l == -1L) {
                size = -1L;
                break;
            }
            size = LongUtils.safeAdd(size, l);
        }
        return new AuthorizableIterator(Iterators.concat(it1, it2), size, filterDuplicates);
    }

    private AuthorizableIterator(Iterator<? extends Authorizable> authorizables, long size, boolean filterDuplicates) {
        if (filterDuplicates) {
            this.servedIds = new HashSet<String>();
            this.authorizables = Iterators.filter(authorizables, authorizable -> {
                if (authorizable == null) {
                    return false;
                }
                String id = Utils.getIdOrNull(authorizable);
                return id != null && this.servedIds.add(id);
            });
        } else {
            this.servedIds = null;
            this.authorizables = Iterators.filter(authorizables, Objects::nonNull);
        }
        this.size = size;
    }

    @Override
    public boolean hasNext() {
        return this.authorizables.hasNext();
    }

    @Override
    public Authorizable next() {
        return this.authorizables.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    long getSize() {
        return this.size;
    }

    private static long getSize(Iterator<?> it) {
        if (it instanceof RangeIterator) {
            return ((RangeIterator)it).getSize();
        }
        if (it instanceof AuthorizableIterator) {
            return ((AuthorizableIterator)it).getSize();
        }
        if (!it.hasNext()) {
            return 0L;
        }
        return -1L;
    }

    private static class AuthorizableTypePredicate
    implements Predicate<Authorizable> {
        private final AuthorizableType authorizableType;

        AuthorizableTypePredicate(@NotNull AuthorizableType authorizableType) {
            this.authorizableType = authorizableType;
        }

        @Override
        public boolean test(Authorizable authorizable) {
            return this.authorizableType.isType(authorizable);
        }
    }

    private static class TreeToAuthorizable
    implements Function<Tree, Authorizable> {
        private final UserManagerImpl userManager;
        private final Predicate<Authorizable> predicate;

        TreeToAuthorizable(UserManagerImpl userManager, AuthorizableType type) {
            this.userManager = userManager;
            this.predicate = new AuthorizableTypePredicate(type);
        }

        @Override
        public Authorizable apply(Tree tree) {
            try {
                Authorizable a = this.userManager.getAuthorizable(tree);
                if (this.predicate.test(a)) {
                    return a;
                }
            }
            catch (RepositoryException e) {
                log.debug("Failed to access authorizable {}", (Object)tree.getPath());
            }
            return null;
        }
    }
}

