/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.commit.DefaultThreeWayConflictHandler;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheConflictHandler
extends DefaultThreeWayConflictHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CacheConflictHandler.class);

    protected CacheConflictHandler() {
        super(ThreeWayConflictHandler.Resolution.IGNORED);
    }

    private ThreeWayConflictHandler.Resolution resolveRepExpirationConflict(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, PropertyState base) {
        if ("rep:expiration".equals(ours.getName()) && "rep:expiration".equals(theirs.getName())) {
            PropertyBuilder<Long> merged = PropertyBuilder.scalar(Type.LONG);
            merged.setName("rep:expiration");
            if (base != null && base.getValue(Type.LONG) > ours.getValue(Type.LONG) && base.getValue(Type.LONG) > theirs.getValue(Type.LONG)) {
                merged.setValue(base.getValue(Type.LONG));
                LOG.warn("base is bigger than ours and theirs. This was supposed to never happens");
                return ThreeWayConflictHandler.Resolution.MERGED;
            }
            if (ours.getValue(Type.LONG) > theirs.getValue(Type.LONG)) {
                merged.setValue(ours.getValue(Type.LONG));
            } else {
                merged.setValue(theirs.getValue(Type.LONG));
            }
            parent.setProperty(merged.getPropertyState());
            LOG.debug("Resolved conflict for property {} our value: {}, their value {}, merged value: {}", new Object[]{"rep:expiration", ours.getValue(Type.LONG), theirs.getValue(Type.LONG), merged.getValue(0)});
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    public ThreeWayConflictHandler.Resolution changeChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        return this.resolveRepExpirationConflict(parent, ours, theirs, base);
    }
}

