/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Predicates;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeclaredMembershipPredicate
implements Predicate<Authorizable> {
    private static final Logger log = LoggerFactory.getLogger(DeclaredMembershipPredicate.class);
    private final MembershipProvider membershipProvider;
    private final Iterator<String> contentIdIterator;
    private final Set<String> declaredMemberContentIds = new HashSet<String>();

    public DeclaredMembershipPredicate(UserManagerImpl userManager, String groupId) {
        this.membershipProvider = userManager.getMembershipProvider();
        Tree groupTree = this.membershipProvider.getByID(groupId, AuthorizableType.GROUP);
        this.contentIdIterator = groupTree == null ? Collections.emptyIterator() : Iterators.filter(this.membershipProvider.getDeclaredMemberContentIDs(groupTree), Predicates.notNull());
    }

    @Override
    public boolean apply(@Nullable Authorizable authorizable) {
        String id = this.saveGetContentId(authorizable);
        if (id != null) {
            if (this.declaredMemberContentIds.contains(id)) {
                return true;
            }
            while (this.contentIdIterator.hasNext()) {
                String memberContentId = this.contentIdIterator.next();
                this.declaredMemberContentIds.add(memberContentId);
                if (!memberContentId.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private String saveGetContentId(@Nullable Authorizable authorizable) {
        if (authorizable != null) {
            try {
                return this.membershipProvider.getContentID(authorizable.getID());
            }
            catch (RepositoryException e) {
                log.debug("Error while retrieving ID for authorizable {}", (Object)authorizable, (Object)e);
            }
        }
        return null;
    }
}

