/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.security.user.AbstractGroupPrincipal;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableIterator;
import org.apache.jackrabbit.oak.security.user.InheritedMembersIterator;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupImpl
extends AuthorizableImpl
implements Group {
    private static final Logger log = LoggerFactory.getLogger(GroupImpl.class);

    GroupImpl(String id, Tree tree, UserManagerImpl userManager) throws RepositoryException {
        super(id, tree, userManager);
    }

    @Override
    void checkValidTree(@NotNull Tree tree) {
        if (!UserUtil.isType(tree, AuthorizableType.GROUP)) {
            throw new IllegalArgumentException("Invalid group node: node type rep:Group expected.");
        }
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    @NotNull
    public Principal getPrincipal() throws RepositoryException {
        return new GroupPrincipal(this.getPrincipalName(), this.getTree());
    }

    @Override
    @NotNull
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return this.getMembersMonitored(false);
    }

    @Override
    @NotNull
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return this.getMembersMonitored(true);
    }

    @Override
    public boolean isDeclaredMember(@NotNull Authorizable authorizable) throws RepositoryException {
        return this.isMember(authorizable, false);
    }

    @Override
    public boolean isMember(@NotNull Authorizable authorizable) throws RepositoryException {
        return this.isMember(authorizable, true);
    }

    @Override
    public boolean addMember(@NotNull Authorizable authorizable) throws RepositoryException {
        Stopwatch watch = Stopwatch.createStarted();
        boolean success = this.internalAddMember(authorizable);
        this.getMonitor().doneUpdateMembers(watch.elapsed(TimeUnit.NANOSECONDS), 1L, success ? 0L : 1L, false);
        return success;
    }

    private boolean internalAddMember(@NotNull Authorizable authorizable) throws RepositoryException {
        boolean success;
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        DynamicMembershipProvider dmp = this.getUserManager().getDynamicMembershipProvider();
        if (dmp.coversAllMembers(this)) {
            log.debug("Attempt to add member to dynamic group {}", (Object)this.getID());
            return false;
        }
        AuthorizableImpl authorizableImpl = (AuthorizableImpl)authorizable;
        if (authorizableImpl.isEveryone()) {
            log.debug("Attempt to create membership for everyone group.");
            return false;
        }
        String memberID = authorizable.getID();
        if (authorizableImpl.isGroup()) {
            if (this.getID().equals(memberID)) {
                String msg = "Attempt to add a group as member of itself (" + this.getID() + ").";
                log.debug(msg);
                return false;
            }
            if (this.isCyclicMembership((Group)authorizable)) {
                String msg = "Cyclic group membership detected for group " + this.getID() + " and member " + authorizable.getID();
                throw new ConstraintViolationException(msg);
            }
        }
        if (success = this.getMembershipProvider().addMember(this.getTree(), authorizableImpl.getTree())) {
            this.getUserManager().onGroupUpdate(this, false, authorizable);
        }
        return success;
    }

    @Override
    @NotNull
    public Set<String> addMembers(String ... memberIds) throws RepositoryException {
        return this.updateMembersMonitored(false, memberIds);
    }

    @Override
    public boolean removeMember(@NotNull Authorizable authorizable) throws RepositoryException {
        Stopwatch watch = Stopwatch.createStarted();
        boolean success = this.internalRemoveMember(authorizable);
        this.getMonitor().doneUpdateMembers(watch.elapsed(TimeUnit.NANOSECONDS), 1L, success ? 0L : 1L, true);
        return success;
    }

    private boolean internalRemoveMember(@NotNull Authorizable authorizable) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        DynamicMembershipProvider dmp = this.getUserManager().getDynamicMembershipProvider();
        if (dmp.coversAllMembers(this)) {
            log.debug("Attempt to remove member from dynamic group {}", (Object)this.getID());
            return false;
        }
        AuthorizableImpl authorizableImpl = (AuthorizableImpl)authorizable;
        if (authorizableImpl.isEveryone()) {
            log.debug("Attempt to remove membership for everyone group.");
            return false;
        }
        Tree memberTree = authorizableImpl.getTree();
        boolean success = this.getMembershipProvider().removeMember(this.getTree(), memberTree);
        if (success) {
            this.getUserManager().onGroupUpdate(this, true, authorizable);
        }
        return success;
    }

    @Override
    @NotNull
    public Set<String> removeMembers(String ... memberIds) throws RepositoryException {
        return this.updateMembersMonitored(true, memberIds);
    }

    @NotNull
    private Iterator<Authorizable> getMembersMonitored(boolean includeInherited) throws RepositoryException {
        Stopwatch watch = Stopwatch.createStarted();
        Iterator<Authorizable> members = this.getMembers(includeInherited);
        this.getMonitor().doneGetMembers(watch.elapsed(TimeUnit.NANOSECONDS), !includeInherited);
        return members;
    }

    @NotNull
    private Iterator<Authorizable> getMembers(boolean includeInherited) throws RepositoryException {
        UserManagerImpl userMgr = this.getUserManager();
        DynamicMembershipProvider dmp = this.getUserManager().getDynamicMembershipProvider();
        Iterator<Authorizable> dynamicMembers = dmp.getMembers(this, includeInherited);
        if (dmp.coversAllMembers(this)) {
            return AuthorizableIterator.create(true, dynamicMembers);
        }
        Iterator<Tree> trees = this.getMembershipProvider().getMembers(this.getTree(), includeInherited);
        if (!trees.hasNext()) {
            return AuthorizableIterator.create(true, dynamicMembers);
        }
        Iterator<Authorizable> members = AuthorizableIterator.create(trees, userMgr, AuthorizableType.AUTHORIZABLE);
        if (includeInherited) {
            members = new InheritedMembersIterator(members, dmp);
        }
        AuthorizableIterator allMembers = AuthorizableIterator.create(true, dynamicMembers, members);
        return new RangeIteratorAdapter(allMembers, allMembers.getSize());
    }

    private boolean isMember(@NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            return false;
        }
        if (this.getID().equals(authorizable.getID()) || ((AuthorizableImpl)authorizable).isEveryone()) {
            return false;
        }
        DynamicMembershipProvider dmp = this.getUserManager().getDynamicMembershipProvider();
        if (dmp.isMember(this, authorizable, includeInherited)) {
            return true;
        }
        Tree authorizableTree = ((AuthorizableImpl)authorizable).getTree();
        MembershipProvider mgr = this.getUserManager().getMembershipProvider();
        if (includeInherited) {
            return mgr.isMember(this.getTree(), authorizableTree);
        }
        return mgr.isDeclaredMember(this.getTree(), authorizableTree);
    }

    @NotNull
    private Set<String> updateMembersMonitored(boolean isRemove, String ... memberIds) throws RepositoryException {
        Stopwatch watch = Stopwatch.createStarted();
        Set<String> failed = this.updateMembers(isRemove, memberIds);
        this.getMonitor().doneUpdateMembers(watch.elapsed(TimeUnit.NANOSECONDS), memberIds.length, failed.size(), isRemove);
        return failed;
    }

    @NotNull
    private Set<String> updateMembers(boolean isRemove, String ... memberIds) throws RepositoryException {
        HashSet<String> failedIds = Sets.newHashSet(memberIds);
        int importBehavior = UserUtil.getImportBehavior(this.getUserManager().getConfig());
        DynamicMembershipProvider dmp = this.getUserManager().getDynamicMembershipProvider();
        if (dmp.coversAllMembers(this)) {
            String msg = "Attempt to add to or remove from dynamic group {}.";
            log.debug(msg, (Object)this.getID());
            return failedIds;
        }
        HashMap<String, String> updateMap = Maps.newHashMapWithExpectedSize(memberIds.length);
        MembershipProvider mp = this.getMembershipProvider();
        for (String memberId : memberIds) {
            if (Strings.isNullOrEmpty(memberId)) {
                throw new ConstraintViolationException("MemberId must not be null or empty.");
            }
            if (!this.isValidMemberId(memberId, importBehavior)) continue;
            failedIds.remove(memberId);
            updateMap.put(mp.getContentID(memberId), memberId);
        }
        HashSet<String> processedIds = Sets.newHashSet(updateMap.values());
        if (!updateMap.isEmpty()) {
            Set<String> result = isRemove ? mp.removeMembers(this.getTree(), updateMap) : mp.addMembers(this.getTree(), updateMap);
            failedIds.addAll(result);
            processedIds.removeAll(result);
        }
        this.getUserManager().onGroupUpdate(this, isRemove, false, processedIds, failedIds);
        return failedIds;
    }

    private boolean isValidMemberId(@NotNull String memberId, int importBehavior) throws RepositoryException {
        if (this.getID().equals(memberId)) {
            log.debug("Attempt to add or remove a group as member of itself ({}).", (Object)this.getID());
            return false;
        }
        if (2 != importBehavior) {
            Authorizable member = this.getUserManager().getAuthorizable(memberId);
            String msg = null;
            if (member == null) {
                msg = "Attempt to add or remove a non-existing member '" + memberId + "' with ImportBehavior = " + ImportBehavior.nameFromValue(importBehavior);
            } else if (member.isGroup()) {
                if (((AuthorizableImpl)member).isEveryone()) {
                    log.debug("Attempt to add everyone group as member.");
                    return false;
                }
                if (this.isCyclicMembership((Group)member)) {
                    msg = "Cyclic group membership detected for group " + this.getID() + " and member " + member.getID();
                }
            }
            if (msg != null) {
                if (3 == importBehavior) {
                    throw new ConstraintViolationException(msg);
                }
                log.debug(msg);
                return false;
            }
        }
        return true;
    }

    private boolean isCyclicMembership(@NotNull Group member) throws RepositoryException {
        return member.isMember(this);
    }

    private final class GroupPrincipal
    extends AbstractGroupPrincipal {
        private GroupPrincipal(String principalName, Tree groupTree) {
            super(principalName, groupTree, GroupImpl.this.getUserManager().getNamePathMapper());
        }

        @Override
        UserManager getUserManager() {
            return GroupImpl.this.getUserManager();
        }

        @Override
        boolean isEveryone() {
            return GroupImpl.this.isEveryone();
        }

        @Override
        boolean isMember(@NotNull Authorizable authorizable) throws RepositoryException {
            return GroupImpl.this.isMember(authorizable);
        }

        @Override
        @NotNull
        Iterator<Authorizable> getMembers() throws RepositoryException {
            return GroupImpl.this.getMembers();
        }
    }
}

