/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob.split;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.cache.CacheBuilder;
import org.apache.jackrabbit.guava.common.hash.BloomFilter;
import org.apache.jackrabbit.guava.common.hash.Funnels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlobIdSet {
    private static final Logger log = LoggerFactory.getLogger(BlobIdSet.class);
    private final File store;
    private final BloomFilter<CharSequence> bloomFilter;
    private final Cache<String, Boolean> cache;

    BlobIdSet(String repositoryDir, String filename) {
        this.store = new File(new File(repositoryDir), filename);
        this.bloomFilter = BloomFilter.create(Funnels.stringFunnel(Charsets.UTF_8), 9000000);
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        this.fillBloomFilter();
    }

    synchronized boolean contains(String blobId) throws IOException {
        if (!this.bloomFilter.apply(blobId)) {
            return false;
        }
        Boolean cached = this.cache.getIfPresent(blobId);
        if (cached != null) {
            return cached;
        }
        if (this.isPresentInStore(blobId)) {
            this.cache.put(blobId, Boolean.TRUE);
            this.bloomFilter.put(blobId);
            return true;
        }
        this.cache.put(blobId, Boolean.FALSE);
        return false;
    }

    synchronized void add(String blobId) throws IOException {
        this.addToStore(blobId);
        this.bloomFilter.put(blobId);
        this.cache.put(blobId, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPresentInStore(String blobId) throws FileNotFoundException, IOException {
        if (!this.store.exists()) {
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.store));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.equals(blobId)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void addToStore(String blobId) throws IOException {
        try (FileWriter writer = new FileWriter(this.store.getPath(), true);){
            writer.append(blobId).append('\n');
        }
    }

    private void fillBloomFilter() {
        if (!this.store.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.store));
            while ((line = reader.readLine()) != null) {
                this.bloomFilter.put(line);
            }
        }
        catch (IOException e) {
            try {
                log.error("Can't fill bloom filter", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
    }
}

