/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;

public abstract class DiffObserver
implements Observer {
    private NodeState before = null;

    protected abstract NodeStateDiff getRootDiff(@NotNull NodeState var1, @NotNull NodeState var2, @NotNull CommitInfo var3);

    @Override
    public final synchronized void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        Preconditions.checkNotNull(root);
        if (this.before != null) {
            NodeStateDiff diff = this.getRootDiff(this.before, root, info);
            root.compareAgainstBaseState(this.before, diff);
        }
        this.before = root;
    }
}

