/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import org.apache.jackrabbit.guava.common.base.Objects;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.jetbrains.annotations.NotNull;

public class RestrictionDefinitionImpl
implements RestrictionDefinition {
    private final String name;
    private final Type<?> type;
    private final boolean isMandatory;

    public RestrictionDefinitionImpl(@NotNull String name, Type<?> type, boolean isMandatory) {
        this.name = Preconditions.checkNotNull(name);
        if (type.tag() == 0) {
            throw new IllegalArgumentException("'undefined' is not a valid required definition type.");
        }
        this.type = type;
        this.isMandatory = isMandatory;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Type<?> getRequiredType() {
        return this.type;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.type, this.isMandatory);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RestrictionDefinitionImpl) {
            RestrictionDefinitionImpl other = (RestrictionDefinitionImpl)o;
            return this.type == other.type && this.isMandatory == other.isMandatory && this.name.equals(other.name);
        }
        return false;
    }
}

