/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.security.Principal;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.oak.spi.security.principal.EmptyPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositePrincipalProvider
implements PrincipalProvider {
    private final List<PrincipalProvider> providers;

    public CompositePrincipalProvider(List<PrincipalProvider> providers) {
        this.providers = Preconditions.checkNotNull(providers);
    }

    public static PrincipalProvider of(@NotNull List<PrincipalProvider> providers) {
        PrincipalProvider pp;
        switch (providers.size()) {
            case 0: {
                pp = EmptyPrincipalProvider.INSTANCE;
                break;
            }
            case 1: {
                pp = providers.get(0);
                break;
            }
            default: {
                pp = new CompositePrincipalProvider(providers);
            }
        }
        return pp;
    }

    @Override
    @Nullable
    public Principal getPrincipal(@NotNull String principalName) {
        Principal principal = null;
        for (int i = 0; i < this.providers.size() && principal == null; ++i) {
            principal = this.providers.get(i).getPrincipal(principalName);
        }
        return principal;
    }

    @Override
    @Nullable
    public ItemBasedPrincipal getItemBasedPrincipal(@NotNull String principalOakPath) {
        for (PrincipalProvider provider : this.providers) {
            ItemBasedPrincipal principal = provider.getItemBasedPrincipal(principalOakPath);
            if (principal == null) continue;
            return principal;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<Principal> getMembershipPrincipals(@NotNull Principal principal) {
        HashSet<Principal> groups = new HashSet<Principal>();
        for (PrincipalProvider provider : this.providers) {
            groups.addAll(provider.getMembershipPrincipals(principal));
        }
        return groups;
    }

    @NotNull
    public Set<Principal> getPrincipals(@NotNull String userID) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (PrincipalProvider provider : this.providers) {
            principals.addAll(provider.getPrincipals(userID));
        }
        return principals;
    }

    @NotNull
    public Iterator<Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        Iterator[] iterators = new Iterator[this.providers.size()];
        int i = 0;
        for (PrincipalProvider provider : this.providers) {
            if (nameHint == null) {
                iterators[i++] = provider.findPrincipals(searchType);
                continue;
            }
            iterators[i++] = provider.findPrincipals(nameHint, searchType);
        }
        return Iterators.concat(iterators);
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, boolean fullText, int searchType, long offset, long limit) {
        List all = this.providers.stream().map(p -> p.findPrincipals(nameHint, fullText, searchType, 0L, limit + offset)).collect(Collectors.toList());
        UnmodifiableIterator<Principal> principals = Iterators.mergeSorted(all, Comparator.comparing(Principal::getName));
        Spliterator<Principal> spliterator = Spliterators.spliteratorUnknownSize(principals, 0);
        Stream<Principal> stream = StreamSupport.stream(spliterator, false);
        if (offset > 0L) {
            stream = stream.skip(offset);
        }
        if (limit >= 0L) {
            stream = stream.limit(limit);
        }
        return stream.iterator();
    }
}

