/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.ClearMembershipAction;
import org.apache.jackrabbit.oak.spi.security.user.action.PasswordChangeAction;
import org.apache.jackrabbit.oak.spi.security.user.action.PasswordValidationAction;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AuthorizableActionProvider.class}, property={"oak.security.name=org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider"})
@Designate(ocd=Configuration.class)
public class DefaultAuthorizableActionProvider
implements AuthorizableActionProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthorizableActionProvider.class);
    private static final Map<String, Class<? extends AuthorizableAction>> SUPPORTED_ACTIONS = ImmutableMap.of(AccessControlAction.class.getName(), AccessControlAction.class, PasswordValidationAction.class.getName(), PasswordValidationAction.class, PasswordChangeAction.class.getName(), PasswordChangeAction.class, ClearMembershipAction.class.getName(), ClearMembershipAction.class);
    private static final String[] DEFAULT_ACTIONS = new String[]{AccessControlAction.class.getName()};
    static final String ENABLED_ACTIONS = "enabledActions";
    private String[] enabledActions = DEFAULT_ACTIONS;
    private ConfigurationParameters config = ConfigurationParameters.EMPTY;

    public DefaultAuthorizableActionProvider() {
    }

    public DefaultAuthorizableActionProvider(ConfigurationParameters config) {
        if (config != null) {
            this.activate(config);
        }
    }

    @Override
    @NotNull
    public List<? extends AuthorizableAction> getAuthorizableActions(@NotNull SecurityProvider securityProvider) {
        ArrayList<AuthorizableAction> actions = Lists.newArrayListWithExpectedSize(this.enabledActions.length);
        for (String className : this.enabledActions) {
            try {
                Class<? extends AuthorizableAction> cl = SUPPORTED_ACTIONS.get(className);
                if (cl == null) continue;
                AuthorizableAction action = cl.newInstance();
                action.init(securityProvider, this.config);
                actions.add(action);
            }
            catch (Exception e) {
                log.debug("Unable to create authorizable action", (Throwable)e);
            }
        }
        return actions;
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.config = ConfigurationParameters.of(properties);
        this.enabledActions = this.config.getConfigValue(ENABLED_ACTIONS, DEFAULT_ACTIONS);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak AuthorizableActionProvider")
    static @interface Configuration {
        @AttributeDefinition(name="Authorizable Actions", description="The set of actions that is supported by this provider implementation.", cardinality=4, options={@Option(label="AccessControlAction", value="org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction"), @Option(label="PasswordValidationAction", value="org.apache.jackrabbit.oak.spi.security.user.action.PasswordValidationAction"), @Option(label="PasswordChangeAction", value="org.apache.jackrabbit.oak.spi.security.user.action.PasswordChangeAction"), @Option(label="ClearMembershipAction", value="org.apache.jackrabbit.oak.spi.security.user.action.ClearMembershipAction")})
        public String[] enabledActions();

        @AttributeDefinition(name="Configure AccessControlAction: User Privileges", description="The name of the privileges that should be granted to a given user on it's home.")
        public String[] userPrivilegeNames();

        @AttributeDefinition(name="Configure AccessControlAction: Group Privileges", description="The name of the privileges that should be granted to a given group on it's home.")
        public String[] groupPrivilegeNames();

        @AttributeDefinition(name="Configure PasswordValidationAction: Password Constraint", description="A regular expression specifying the pattern that must be matched by a user's password.")
        public String constraint();
    }
}

