/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadyOnlyBuilderException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadOnlyBuilder
implements NodeBuilder {
    @NotNull
    private final NodeState state;

    public ReadOnlyBuilder(@NotNull NodeState state) {
        this.state = Preconditions.checkNotNull(state);
    }

    protected RuntimeException unsupported() {
        return new ReadyOnlyBuilderException("This builder is read-only.");
    }

    @Override
    public boolean exists() {
        return this.state.exists();
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean isNew(String name) {
        return false;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean isReplaced() {
        return false;
    }

    @Override
    public boolean isReplaced(String name) {
        return false;
    }

    @Override
    @NotNull
    public NodeState getNodeState() {
        return this.state;
    }

    @Override
    @NotNull
    public NodeState getBaseState() {
        return this.state;
    }

    @Override
    public long getChildNodeCount(long max) {
        return this.state.getChildNodeCount(max);
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        return this.state.hasChildNode(name);
    }

    @Override
    @NotNull
    public Iterable<String> getChildNodeNames() {
        return this.state.getChildNodeNames();
    }

    @Override
    @NotNull
    public NodeBuilder setChildNode(@NotNull String name, @NotNull NodeState nodeState) {
        throw this.unsupported();
    }

    @Override
    public boolean remove() {
        throw this.unsupported();
    }

    @Override
    public boolean moveTo(@NotNull NodeBuilder newParent, @NotNull String newName) {
        throw this.unsupported();
    }

    @Override
    public long getPropertyCount() {
        return this.state.getPropertyCount();
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return this.state.getProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.state.hasProperty(name);
    }

    @Override
    public PropertyState getProperty(String name) {
        return this.state.getProperty(name);
    }

    @Override
    public boolean getBoolean(@NotNull String name) {
        return this.state.getBoolean(name);
    }

    @Override
    @Nullable
    public String getString(@NotNull String name) {
        return this.state.getString(name);
    }

    @Override
    @Nullable
    public String getName(@NotNull String name) {
        return this.state.getName(name);
    }

    @Override
    @NotNull
    public Iterable<String> getNames(@NotNull String name) {
        return this.state.getNames(name);
    }

    @Override
    @NotNull
    public NodeBuilder removeProperty(String name) {
        throw this.unsupported();
    }

    @Override
    @NotNull
    public NodeBuilder setProperty(@NotNull PropertyState property) {
        throw this.unsupported();
    }

    @Override
    @NotNull
    public <T> NodeBuilder setProperty(String name, @NotNull T value) {
        throw this.unsupported();
    }

    @Override
    @NotNull
    public <T> NodeBuilder setProperty(String name, @NotNull T value, Type<T> type) {
        throw this.unsupported();
    }

    @Override
    @NotNull
    public ReadOnlyBuilder child(@NotNull String name) {
        NodeState child = this.state.getChildNode(name);
        if (child.exists()) {
            return new ReadOnlyBuilder(child);
        }
        throw this.unsupported();
    }

    @Override
    @NotNull
    public NodeBuilder getChildNode(@NotNull String name) {
        return new ReadOnlyBuilder(this.state.getChildNode(name));
    }

    @Override
    @NotNull
    public NodeBuilder setChildNode(@NotNull String name) {
        throw this.unsupported();
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        throw this.unsupported();
    }
}

