/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.resourceresolver.impl.ResourceResolverImpl;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl;
import org.apache.sling.testing.mock.osgi.MockEventAdmin;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;

abstract class AbstractMockResourceResolverFactory
implements ResourceResolverFactory {
    protected final BundleContext bundleContext;

    public AbstractMockResourceResolverFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected ResourceResolver getResourceResolverInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws LoginException {
        Hashtable<String, Object> resourceProviderFactoryFactoryProps = new Hashtable<String, Object>();
        ((Dictionary)resourceProviderFactoryFactoryProps).put("service.vendor", "sling-mock");
        ((Dictionary)resourceProviderFactoryFactoryProps).put("service.description", "sling-mock");
        ((Dictionary)resourceProviderFactoryFactoryProps).put("resource.resolver.manglenamespaces", true);
        ((Dictionary)resourceProviderFactoryFactoryProps).put("resource.resolver.searchpath", new String[]{"/apps", "/libs"});
        this.ensureResourceResolverFactoryActivatorDependencies();
        ResourceResolverFactoryActivator activator = new ResourceResolverFactoryActivator();
        MockOsgi.injectServices((Object)activator, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)activator, resourceProviderFactoryFactoryProps);
        CommonResourceResolverFactoryImpl commonFactoryImpl = new CommonResourceResolverFactoryImpl(activator);
        ResourceResolverContext context = new ResourceResolverContext(true, authenticationInfo, new ResourceAccessSecurityTracker());
        ResourceResolverImpl resourceResolver = new ResourceResolverImpl(commonFactoryImpl, context);
        return resourceResolver;
    }

    private void ensureResourceResolverFactoryActivatorDependencies() {
        if (this.bundleContext.getServiceReference(ServiceUserMapper.class.getName()) == null) {
            ServiceUserMapperImpl serviceUserMapper = new ServiceUserMapperImpl();
            MockOsgi.injectServices((Object)serviceUserMapper, (BundleContext)this.bundleContext);
            MockOsgi.activate((Object)serviceUserMapper);
            this.bundleContext.registerService(ServiceUserMapper.class.getName(), (Object)serviceUserMapper, null);
        }
        if (this.bundleContext.getServiceReference(ResourceAccessSecurityTracker.class.getName()) == null) {
            ResourceAccessSecurityTracker resourceAccessSecurityTracker = new ResourceAccessSecurityTracker();
            MockOsgi.injectServices((Object)resourceAccessSecurityTracker, (BundleContext)this.bundleContext);
            MockOsgi.activate((Object)resourceAccessSecurityTracker);
            this.bundleContext.registerService(ResourceAccessSecurityTracker.class.getName(), (Object)resourceAccessSecurityTracker, null);
        }
        if (this.bundleContext.getServiceReference(EventAdmin.class.getName()) == null) {
            MockEventAdmin eventAdmin = new MockEventAdmin();
            MockOsgi.injectServices((Object)eventAdmin, (BundleContext)this.bundleContext);
            MockOsgi.activate((Object)eventAdmin);
            this.bundleContext.registerService(EventAdmin.class.getName(), (Object)eventAdmin, null);
        }
    }

    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolverInternal(authenticationInfo, false);
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolverInternal(authenticationInfo, true);
    }

    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolverInternal(authenticationInfo, true);
    }

    public ResourceResolver getThreadResourceResolver() {
        throw new UnsupportedOperationException();
    }
}

