/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockJcrResourceResolverFactory;
import org.apache.sling.testing.mock.sling.MockNoneResourceResolverFactory;
import org.apache.sling.testing.mock.sling.MockSlingScriptHelper;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.ThreadsafeMockAdapterManagerWrapper;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.apache.sling.testing.mock.sling.spi.ResourceResolverTypeAdapter;
import org.osgi.framework.BundleContext;

public final class MockSling {
    public static final ResourceResolverType DEFAULT_RESOURCERESOLVER_TYPE = ResourceResolverType.RESOURCERESOLVER_MOCK;
    private static final ThreadsafeMockAdapterManagerWrapper ADAPTER_MANAGER = new ThreadsafeMockAdapterManagerWrapper();

    private MockSling() {
    }

    public static ResourceResolverFactory newResourceResolverFactory(ResourceResolverType type) {
        return MockSling.newResourceResolverFactory(type, MockOsgi.newBundleContext());
    }

    public static ResourceResolverFactory newResourceResolverFactory(ResourceResolverType type, BundleContext bundleContext) {
        ResourceResolverTypeAdapter adapter = MockSling.getResourceResolverTypeAdapter(type);
        ResourceResolverFactory factory = adapter.newResourceResolverFactory();
        if (factory == null) {
            SlingRepository repository = adapter.newSlingRepository();
            factory = repository == null ? new MockNoneResourceResolverFactory(bundleContext) : new MockJcrResourceResolverFactory(repository, bundleContext);
        }
        return factory;
    }

    private static ResourceResolverTypeAdapter getResourceResolverTypeAdapter(ResourceResolverType type) {
        try {
            Class<?> clazz = Class.forName(type.getResourceResolverTypeAdapterClass());
            return (ResourceResolverTypeAdapter)clazz.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to instantiate resourcer resolver: " + type.getResourceResolverTypeAdapterClass() + (type.getArtifactCoordinates() != null ? "Make sure this maven dependency is included: " + type.getArtifactCoordinates() : ""), ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to instantiate resourcer resolver: " + type.getResourceResolverTypeAdapterClass() + (type.getArtifactCoordinates() != null ? "Make sure this maven dependency is included: " + type.getArtifactCoordinates() : ""), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to instantiate resourcer resolver: " + type.getResourceResolverTypeAdapterClass() + (type.getArtifactCoordinates() != null ? "Make sure this maven dependency is included: " + type.getArtifactCoordinates() : ""), ex);
        }
    }

    public static ResourceResolverFactory newResourceResolverFactory() {
        return MockSling.newResourceResolverFactory(DEFAULT_RESOURCERESOLVER_TYPE);
    }

    public static ResourceResolver newResourceResolver(ResourceResolverType type) {
        ResourceResolverFactory factory = MockSling.newResourceResolverFactory(type);
        try {
            return factory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException ex) {
            throw new RuntimeException("Mock resource resolver factory implementation seems to require login.", ex);
        }
    }

    public static ResourceResolver newResourceResolver() {
        return MockSling.newResourceResolver(DEFAULT_RESOURCERESOLVER_TYPE);
    }

    public static SlingScriptHelper newSlingScriptHelper(SlingHttpServletRequest request, SlingHttpServletResponse response, BundleContext bundleContext) {
        return new MockSlingScriptHelper(request, response, bundleContext);
    }

    public static SlingScriptHelper newSlingScriptHelper() {
        MockSlingHttpServletRequest request = new MockSlingHttpServletRequest(MockSling.newResourceResolver());
        MockSlingHttpServletResponse response = new MockSlingHttpServletResponse();
        BundleContext bundleContext = MockOsgi.newBundleContext();
        return MockSling.newSlingScriptHelper(request, response, bundleContext);
    }

    public static void setAdapterManagerBundleContext(BundleContext bundleContext) {
        ADAPTER_MANAGER.setBundleContext(bundleContext);
    }

    public static void clearAdapterManagerBundleContext() {
        ADAPTER_MANAGER.clearBundleContext();
    }

    static {
        SlingAdaptable.setAdapterManager((AdapterManager)ADAPTER_MANAGER);
    }
}

