/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import aQute.bnd.annotation.ConsumerType;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.impl.FirstImplementationPicker;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.BindingsInjector;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.OSGiServiceInjector;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.impl.injectors.ResourcePathInjector;
import org.apache.sling.models.impl.injectors.SelfInjector;
import org.apache.sling.models.impl.injectors.SlingObjectInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.builder.ContentBuilder;
import org.apache.sling.testing.mock.sling.context.ContextResourceResolverFactory;
import org.apache.sling.testing.mock.sling.context.ModelAdapterFactoryUtil;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.apache.sling.testing.mock.sling.services.MockMimeTypeService;
import org.apache.sling.testing.mock.sling.services.MockSlingSettingService;
import org.apache.sling.testing.mock.sling.servlet.MockRequestPathInfo;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.osgi.framework.ServiceReference;

@ConsumerType
public class SlingContextImpl
extends OsgiContextImpl {
    static final Set<String> DEFAULT_RUN_MODES = ImmutableSet.builder().add((Object)"publish").build();
    protected ResourceResolverFactory resourceResolverFactory;
    protected ResourceResolverType resourceResolverType;
    protected ResourceResolver resourceResolver;
    protected MockSlingHttpServletRequest request;
    protected MockSlingHttpServletResponse response;
    protected SlingScriptHelper slingScriptHelper;
    protected ContentLoader contentLoader;
    protected ContentBuilder contentBuilder;

    protected void setResourceResolverType(ResourceResolverType resourceResolverType) {
        this.resourceResolverType = resourceResolverType;
    }

    protected void setUp() {
        super.setUp();
        MockSling.setAdapterManagerBundleContext(this.bundleContext());
        this.resourceResolverFactory = this.newResourceResolverFactory();
        this.registerDefaultServices();
    }

    protected ResourceResolverFactory newResourceResolverFactory() {
        return ContextResourceResolverFactory.get(this.resourceResolverType, this.bundleContext());
    }

    protected void registerDefaultServices() {
        this.registerService(ResourceResolverFactory.class, this.resourceResolverFactory);
        this.registerInjectActivateService(new ModelAdapterFactory());
        this.registerInjectActivateService(new BindingsInjector());
        this.registerInjectActivateService(new ChildResourceInjector());
        this.registerInjectActivateService(new OSGiServiceInjector());
        this.registerInjectActivateService(new RequestAttributeInjector());
        this.registerInjectActivateService(new ResourcePathInjector());
        this.registerInjectActivateService(new SelfInjector());
        this.registerInjectActivateService(new SlingObjectInjector());
        this.registerInjectActivateService(new ValueMapInjector());
        this.registerService(ImplementationPicker.class, new FirstImplementationPicker());
        this.registerService(SlingSettingsService.class, new MockSlingSettingService(DEFAULT_RUN_MODES));
        this.registerService(MimeTypeService.class, (Object)new MockMimeTypeService());
    }

    protected void tearDown() {
        if (this.resourceResolver != null) {
            this.resourceResolver.revert();
            Session session = (Session)this.resourceResolver.adaptTo(Session.class);
            if (session != null) {
                try {
                    session.refresh(false);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
        this.componentContext = null;
        this.resourceResolver = null;
        this.request = null;
        this.response = null;
        this.slingScriptHelper = null;
        this.contentLoader = null;
        this.contentBuilder = null;
        MockSling.clearAdapterManagerBundleContext();
        super.tearDown();
    }

    public final ResourceResolverType resourceResolverType() {
        return this.resourceResolverType;
    }

    public final ResourceResolver resourceResolver() {
        if (this.resourceResolver == null) {
            try {
                this.resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            }
            catch (LoginException ex) {
                throw new RuntimeException("Creating resource resolver failed.", ex);
            }
        }
        return this.resourceResolver;
    }

    public final MockSlingHttpServletRequest request() {
        if (this.request == null) {
            this.request = new MockSlingHttpServletRequest(this.resourceResolver(), this.bundleContext());
            SlingBindings bindings = new SlingBindings();
            bindings.put((Object)"request", (Object)this.request);
            bindings.put((Object)"response", (Object)this.response());
            bindings.put((Object)"sling", (Object)this.slingScriptHelper());
            this.request.setAttribute(SlingBindings.class.getName(), bindings);
        }
        return this.request;
    }

    public final MockRequestPathInfo requestPathInfo() {
        return (MockRequestPathInfo)this.request().getRequestPathInfo();
    }

    public final MockSlingHttpServletResponse response() {
        if (this.response == null) {
            this.response = new MockSlingHttpServletResponse();
        }
        return this.response;
    }

    public final SlingScriptHelper slingScriptHelper() {
        if (this.slingScriptHelper == null) {
            this.slingScriptHelper = MockSling.newSlingScriptHelper(this.request(), this.response(), this.bundleContext());
        }
        return this.slingScriptHelper;
    }

    public ContentLoader load() {
        if (this.contentLoader == null) {
            this.contentLoader = new ContentLoader(this.resourceResolver(), this.bundleContext());
        }
        return this.contentLoader;
    }

    public ContentBuilder create() {
        if (this.contentBuilder == null) {
            this.contentBuilder = new ContentBuilder(this.resourceResolver());
        }
        return this.contentBuilder;
    }

    public final Resource currentResource() {
        return this.request().getResource();
    }

    public final Resource currentResource(String resourcePath) {
        if (resourcePath != null) {
            Resource resource = this.resourceResolver().getResource(resourcePath);
            if (resource == null) {
                throw new IllegalArgumentException("Resource does not exist: " + resourcePath);
            }
            return this.currentResource(resource);
        }
        return this.currentResource((Resource)null);
    }

    public final Resource currentResource(Resource resource) {
        this.request().setResource(resource);
        return resource;
    }

    public final void addModelsForPackage(String packageName) {
        ModelAdapterFactoryUtil.addModelsForPackage(packageName, this.bundleContext());
    }

    public final void runMode(String ... runModes) {
        ImmutableSet newRunModes = ImmutableSet.builder().add((Object[])runModes).build();
        ServiceReference ref = this.bundleContext().getServiceReference(SlingSettingsService.class.getName());
        if (ref != null) {
            MockSlingSettingService slingSettings = (MockSlingSettingService)this.bundleContext().getService(ref);
            slingSettings.setRunModes((Set<String>)newRunModes);
        }
    }
}

