/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.junit;

import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.apache.sling.testing.mock.sling.junit.SlingContextCallback;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class SlingContext
extends SlingContextImpl
implements TestRule {
    private final SlingContextCallback setUpCallback;
    private final SlingContextCallback tearDownCallback;
    private final TestRule delegate;

    public SlingContext() {
        this(null, null, null);
    }

    public SlingContext(ResourceResolverType resourceResolverType) {
        this(null, null, resourceResolverType);
    }

    public SlingContext(SlingContextCallback setUpCallback) {
        this(setUpCallback, null, null);
    }

    public SlingContext(SlingContextCallback setUpCallback, ResourceResolverType resourceResolverType) {
        this(setUpCallback, null, resourceResolverType);
    }

    public SlingContext(SlingContextCallback setUpCallback, SlingContextCallback tearDownCallback) {
        this(setUpCallback, tearDownCallback, null);
    }

    public SlingContext(SlingContextCallback setUpCallback, SlingContextCallback tearDownCallback, ResourceResolverType resourceResolverType) {
        this.setUpCallback = setUpCallback;
        this.tearDownCallback = tearDownCallback;
        this.setResourceResolverType(resourceResolverType);
        this.delegate = new ExternalResource(){

            protected void before() {
                SlingContext.this.setUp();
                SlingContext.this.executeSetUpCallback();
            }

            protected void after() {
                SlingContext.this.executeTearDownCallback();
                SlingContext.this.tearDown();
            }
        };
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }

    private void executeSetUpCallback() {
        if (this.setUpCallback != null) {
            try {
                this.setUpCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Executing setup callback failed.", ex);
            }
        }
    }

    private void executeTearDownCallback() {
        if (this.tearDownCallback != null) {
            try {
                this.tearDownCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Executing setup callback failed.", ex);
            }
        }
    }
}

