/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import com.google.common.collect.ImmutableMap;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.AbstractMockResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class MockJcrResourceResolverFactory
extends AbstractMockResourceResolverFactory {
    private final SlingRepository slingRepository;

    public MockJcrResourceResolverFactory(SlingRepository repository, BundleContext bundleContext) {
        super(bundleContext);
        this.slingRepository = repository;
    }

    @Override
    protected ResourceResolver getResourceResolverInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws LoginException {
        if (this.bundleContext.getServiceReference(SlingRepository.class.getName()) == null) {
            this.bundleContext.registerService(SlingRepository.class.getName(), (Object)this.slingRepository, null);
        }
        this.registerServiceIfFoundInClasspath("org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper");
        JcrResourceProviderFactory jcrResourceProviderFactory = new JcrResourceProviderFactory();
        MockOsgi.injectServices((Object)jcrResourceProviderFactory, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)jcrResourceProviderFactory, (BundleContext)this.bundleContext, (Map)ImmutableMap.of());
        ResourceProvider resourceProvider = isAdmin ? jcrResourceProviderFactory.getAdministrativeResourceProvider(authenticationInfo) : jcrResourceProviderFactory.getResourceProvider(authenticationInfo);
        if (!this.isRootServiceProviderRegistered(this.bundleContext)) {
            Hashtable<String, String[]> resourceProviderProps = new Hashtable<String, String[]>();
            ((Dictionary)resourceProviderProps).put("provider.roots", new String[]{"/"});
            ((Dictionary)resourceProviderProps).put("provider.query.languages", new String[]{"xpath", "sql", "JCR-SQL2"});
            this.bundleContext.registerService(ResourceProvider.class.getName(), (Object)resourceProvider, resourceProviderProps);
        }
        return super.getResourceResolverInternal(authenticationInfo, isAdmin);
    }

    private boolean isRootServiceProviderRegistered(BundleContext bundleContext) {
        try {
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(ResourceProvider.class.getName(), null);
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    Object[] roots = PropertiesUtil.toStringArray((Object)serviceReference.getProperty("provider.roots"));
                    if (!ArrayUtils.contains((Object[])roots, (Object)"/")) continue;
                    return true;
                }
            }
            return false;
        }
        catch (InvalidSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void registerServiceIfFoundInClasspath(String className) {
        try {
            Class<?> pathMapperClass = Class.forName(className);
            if (this.bundleContext.getServiceReference(className) == null) {
                Object instance = pathMapperClass.newInstance();
                MockOsgi.injectServices(instance, (BundleContext)this.bundleContext);
                MockOsgi.activate(instance);
                this.bundleContext.registerService(className, instance, null);
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

