/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.contentparser.ContentHandler;
import org.apache.sling.jcr.contentparser.ContentParser;
import org.apache.sling.jcr.contentparser.ContentParserFactory;
import org.apache.sling.jcr.contentparser.ContentType;
import org.apache.sling.jcr.contentparser.ParseException;
import org.apache.sling.jcr.contentparser.ParserOptions;
import org.apache.sling.testing.mock.sling.loader.LoaderContentHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ContentLoader {
    private static final String CONTENTTYPE_OCTET_STREAM = "application/octet-stream";
    private static final Set<String> IGNORED_NAMES = ImmutableSet.of((Object)"jcr:mixinTypes", (Object)"jcr:uuid", (Object)"jcr:baseVersion", (Object)"jcr:predecessors", (Object)"jcr:successors", (Object)"jcr:created", (Object[])new String[]{"jcr:versionHistory", "jcr:checkedOut", "jcr:isCheckedOut", "rep:policy"});
    private static ContentParser JSON_PARSER = ContentParserFactory.create((ContentType)ContentType.JSON, (ParserOptions)new ParserOptions().detectCalendarValues(true).ignorePropertyNames(IGNORED_NAMES).ignoreResourceNames(IGNORED_NAMES));
    private final ResourceResolver resourceResolver;
    private final BundleContext bundleContext;
    private final boolean autoCommit;

    public ContentLoader(ResourceResolver resourceResolver) {
        this(resourceResolver, null);
    }

    public ContentLoader(ResourceResolver resourceResolver, BundleContext bundleContext) {
        this(resourceResolver, bundleContext, true);
    }

    public ContentLoader(ResourceResolver resourceResolver, BundleContext bundleContext, boolean autoCommit) {
        this.resourceResolver = resourceResolver;
        this.bundleContext = bundleContext;
        this.autoCommit = autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource json(String classpathResource, Resource parentResource, String childName) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.json(is, parentResource, childName);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource json(String classpathResource, String destPath) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.json(is, destPath);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Resource json(InputStream inputStream, Resource parentResource, String childName) {
        return this.json(inputStream, parentResource.getPath() + "/" + childName);
    }

    public Resource json(InputStream inputStream, String destPath) {
        try {
            String parentPath = ResourceUtil.getParent((String)destPath);
            String childName = ResourceUtil.getName((String)destPath);
            Resource parentResource = this.resourceResolver.getResource(parentPath);
            if (parentResource == null) {
                parentResource = this.createResourceHierarchy(parentPath);
            }
            if (parentResource.getChild(childName) != null) {
                throw new IllegalArgumentException("Resource does already exist: " + destPath);
            }
            LoaderContentHandler contentHandler = new LoaderContentHandler(destPath, this.resourceResolver);
            JSON_PARSER.parse((ContentHandler)contentHandler, inputStream);
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return this.resourceResolver.getResource(destPath);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Resource createResourceHierarchy(String path) {
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            return null;
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jcr:primaryType", "nt:unstructured");
        try {
            return this.resourceResolver.create(parentResource, ResourceUtil.getName((String)path), props);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource binaryFile(String classpathResource, String path) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryFile(is, path, this.detectMimeTypeFromName(path));
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource binaryFile(String classpathResource, String path, String mimeType) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryFile(is, path, mimeType);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Resource binaryFile(InputStream inputStream, String path) {
        return this.binaryFile(inputStream, path, this.detectMimeTypeFromName(path));
    }

    public Resource binaryFile(InputStream inputStream, String path, String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryFile(inputStream, parentResource, name, mimeType);
    }

    public Resource binaryFile(InputStream inputStream, Resource parentResource, String name) {
        return this.binaryFile(inputStream, parentResource, name, this.detectMimeTypeFromName(name));
    }

    public Resource binaryFile(InputStream inputStream, Resource parentResource, String name, String mimeType) {
        try {
            Resource file = this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:file").build());
            this.resourceResolver.create(file, "jcr:content", (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:resource").put((Object)"jcr:data", (Object)inputStream).put((Object)"jcr:mimeType", (Object)mimeType).build());
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return file;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource binaryResource(String classpathResource, String path) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryResource(is, path, this.detectMimeTypeFromName(path));
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource binaryResource(String classpathResource, String path, String mimeType) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryResource(is, path, mimeType);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Resource binaryResource(InputStream inputStream, String path) {
        return this.binaryResource(inputStream, path, this.detectMimeTypeFromName(path));
    }

    public Resource binaryResource(InputStream inputStream, String path, String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryResource(inputStream, parentResource, name, mimeType);
    }

    public Resource binaryResource(InputStream inputStream, Resource parentResource, String name) {
        return this.binaryResource(inputStream, parentResource, name, this.detectMimeTypeFromName(name));
    }

    public Resource binaryResource(InputStream inputStream, Resource parentResource, String name, String mimeType) {
        try {
            Resource resource = this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:resource").put((Object)"jcr:data", (Object)inputStream).put((Object)"jcr:mimeType", (Object)mimeType).build());
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return resource;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    private String detectMimeTypeFromName(String name) {
        ServiceReference ref;
        String mimeType = null;
        String fileExtension = StringUtils.substringAfterLast((String)name, (String)".");
        if (this.bundleContext != null && StringUtils.isNotEmpty((CharSequence)fileExtension) && (ref = this.bundleContext.getServiceReference(MimeTypeService.class)) != null) {
            MimeTypeService mimeTypeService = (MimeTypeService)this.bundleContext.getService(ref);
            mimeType = mimeTypeService.getMimeType(fileExtension);
        }
        return StringUtils.defaultString(mimeType, (String)CONTENTTYPE_OCTET_STREAM);
    }
}

