/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.junit;

import java.util.Map;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugins;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class SlingContext
extends SlingContextImpl
implements TestRule {
    private final ContextPlugins plugins;
    private final TestRule delegate;

    public SlingContext() {
        this(new ContextPlugins(), null, null);
    }

    public SlingContext(ResourceResolverType resourceResolverType) {
        this(new ContextPlugins(), null, resourceResolverType);
    }

    public <T extends OsgiContextImpl> SlingContext(ContextCallback<T> afterSetUpCallback) {
        this(new ContextPlugins(afterSetUpCallback), null, null);
    }

    public <T extends OsgiContextImpl> SlingContext(ContextCallback<T> afterSetUpCallback, ResourceResolverType resourceResolverType) {
        this(new ContextPlugins(afterSetUpCallback), null, resourceResolverType);
    }

    public <U extends OsgiContextImpl, V extends OsgiContextImpl> SlingContext(ContextCallback<U> afterSetUpCallback, ContextCallback<V> beforeTearDownCallback) {
        this(new ContextPlugins(afterSetUpCallback, beforeTearDownCallback), null, null);
    }

    public <U extends OsgiContextImpl, V extends OsgiContextImpl> SlingContext(ContextCallback<U> afterSetUpCallback, ContextCallback<V> beforeTearDownCallback, ResourceResolverType resourceResolverType) {
        this(new ContextPlugins(afterSetUpCallback, beforeTearDownCallback), null, resourceResolverType);
    }

    SlingContext(ContextPlugins contextPlugins, Map<String, Object> resourceResolverFactoryActivatorProps, ResourceResolverType resourceResolverType) {
        this.plugins = contextPlugins;
        this.setResourceResolverFactoryActivatorProps(resourceResolverFactoryActivatorProps);
        this.setResourceResolverType(resourceResolverType);
        this.delegate = new ExternalResource(){

            protected void before() {
                SlingContext.this.plugins.executeBeforeSetUpCallback((OsgiContextImpl)SlingContext.this);
                SlingContext.this.setUp();
                SlingContext.this.plugins.executeAfterSetUpCallback((OsgiContextImpl)SlingContext.this);
            }

            protected void after() {
                SlingContext.this.plugins.executeBeforeTearDownCallback((OsgiContextImpl)SlingContext.this);
                SlingContext.this.tearDown();
                SlingContext.this.plugins.executeAfterTearDownCallback((OsgiContextImpl)SlingContext.this);
            }
        };
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }
}

