/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.services;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Map;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.mime.internal.MimeTypeServiceImpl;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;

@Component(service={MimeTypeService.class})
public final class MockMimeTypeService
extends MimeTypeServiceImpl {
    private boolean initialized;

    private void lazyInitialization() {
        if (!this.initialized) {
            this.initialized = true;
            ComponentContext componentContext = MockOsgi.newComponentContext();
            this.bindLogService(MockOsgi.newLogService(((Object)((Object)this)).getClass()));
            try {
                try {
                    Method activateMethod = MimeTypeServiceImpl.class.getDeclaredMethod("activate", ComponentContext.class);
                    activateMethod.invoke((Object)this, componentContext);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        Method activateMethod = MimeTypeServiceImpl.class.getDeclaredMethod("activate", BundleContext.class, Map.class);
                        activateMethod.invoke((Object)this, componentContext.getBundleContext(), MapUtil.toMap((Dictionary)componentContext.getProperties()));
                    }
                    catch (NoSuchMethodException ex1) {
                        throw new RuntimeException("Did not found activate method of MimeTypeServiceImpl with any matching signature.");
                    }
                }
            }
            catch (IllegalAccessException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException("Unable to activate MimeTypeServiceImpl.", ex);
            }
        }
    }

    public String getMimeType(String name) {
        this.lazyInitialization();
        return super.getMimeType(name);
    }

    public String getExtension(String mimeType) {
        this.lazyInitialization();
        return super.getExtension(mimeType);
    }

    public void registerMimeType(String mimeType, String ... extensions) {
        this.lazyInitialization();
        super.registerMimeType(mimeType, extensions);
    }

    public void registerMimeType(InputStream mimeTabStream) throws IOException {
        this.lazyInitialization();
        super.registerMimeType(mimeTabStream);
    }
}

