/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.xss.ProtectionContext;
import org.apache.sling.xss.XSSFilter;
import org.apache.sling.xss.impl.HtmlToHtmlContentContext;
import org.apache.sling.xss.impl.PlainTextToHtmlContentContext;
import org.apache.sling.xss.impl.PolicyHandler;
import org.apache.sling.xss.impl.XSSFilterRule;
import org.owasp.validator.html.model.Attribute;
import org.owasp.validator.html.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={ResourceChangeListener.class, XSSFilter.class})
@Properties(value={@Property(name="resource.change.types", value={"ADDED", "CHANGED", "REMOVED"}), @Property(name="resource.paths", value={"sling/xss/config.xml"})})
public class XSSFilterImpl
implements XSSFilter,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSSFilterImpl.class);
    static final Attribute DEFAULT_HREF_ATTRIBUTE = new Attribute("href", Arrays.asList(Pattern.compile("([\\p{L}\\p{M}*+\\p{N}\\\\\\.\\#@\\$%\\+&;\\-_~,\\?=/!\\*\\(\\)]*|\\#(\\w)+)"), Pattern.compile("(\\s)*((ht|f)tp(s?)://|mailto:)[\\p{L}\\p{M}*+\\p{N}]+[\\p{L}\\p{M}*+\\p{N}\\p{Zs}\\.\\#@\\$%\\+&;:\\-_~,\\?=/!\\*\\(\\)]*(\\s)*")), Collections.emptyList(), "removeAttribute", "");
    public static final String DEFAULT_POLICY_PATH = "sling/xss/config.xml";
    private static final String EMBEDDED_POLICY_PATH = "SLING-INF/content/config.xml";
    private static final String SLING_XSS_USER = "sling-xss";
    private static final int DEFAULT_POLICY_CACHE_SIZE = 128;
    private PolicyHandler defaultHandler;
    private Attribute hrefAttribute;
    private final XSSFilterRule htmlHtmlContext = new HtmlToHtmlContentContext();
    private final XSSFilterRule plainHtmlContext = new PlainTextToHtmlContentContext();
    private Map<String, PolicyHandler> policies = new ConcurrentHashMap<String, PolicyHandler>();
    @Reference
    private ResourceResolverFactory resourceResolverFactory = null;

    public void onChange(List<ResourceChange> resourceChanges) {
        for (ResourceChange change : resourceChanges) {
            if (!change.getPath().endsWith(DEFAULT_POLICY_PATH)) continue;
            LOGGER.info("Detected policy file change ({}) at {}. Updating default handler.", (Object)change.getType().name(), (Object)change.getPath());
            this.updateDefaultHandler();
        }
    }

    @Override
    public boolean check(ProtectionContext context, String src) {
        return this.check(context, src, null);
    }

    @Override
    public String filter(String src) {
        return this.filter(XSSFilter.DEFAULT_CONTEXT, src);
    }

    @Override
    public String filter(ProtectionContext context, String src) {
        return this.filter(context, src, null);
    }

    @Activate
    protected void activate() {
        this.updateDefaultHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateDefaultHandler() {
        this.defaultHandler = null;
        try (ResourceResolver xssResourceResolver = null;){
            HashMap<String, Object> authenticationInfo = new HashMap<String, Object>(){
                {
                    this.put("sling.service.subservice", XSSFilterImpl.SLING_XSS_USER);
                }
            };
            xssResourceResolver = this.resourceResolverFactory.getServiceResourceResolver((Map)authenticationInfo);
            Resource policyResource = xssResourceResolver.getResource(DEFAULT_POLICY_PATH);
            if (policyResource != null) {
                try (InputStream policyStream = (InputStream)policyResource.adaptTo(InputStream.class);){
                    this.setDefaultHandler(new PolicyHandler(policyStream));
                    LOGGER.info("Installed default policy from {}.", (Object)policyResource.getPath());
                }
                catch (Exception e) {
                    Throwable[] suppressed = e.getSuppressed();
                    if (suppressed.length > 0) {
                        for (Throwable t : suppressed) {
                            LOGGER.error("Unable to load policy from " + policyResource.getPath(), t);
                        }
                    }
                    LOGGER.error("Unable to load policy from " + policyResource.getPath(), (Throwable)e);
                }
            } else {
                LOGGER.warn("Could not find a policy file at the default location {}. Attempting to use the default resource embedded in the bundle.", (Object)DEFAULT_POLICY_PATH);
                try (InputStream policyStream = this.getClass().getClassLoader().getResourceAsStream(EMBEDDED_POLICY_PATH);){
                    this.setDefaultHandler(new PolicyHandler(policyStream));
                    LOGGER.info("Installed default policy from the embedded {} file from the bundle.", (Object)EMBEDDED_POLICY_PATH);
                }
                catch (Exception e) {
                    Throwable[] suppressed = e.getSuppressed();
                    if (suppressed.length > 0) {
                        for (Throwable t : suppressed) {
                            LOGGER.error("Unable to load policy from embedded policy file.", t);
                        }
                    }
                    LOGGER.error("Unable to load policy from embedded policy file.", (Throwable)e);
                }
            }
            if (this.defaultHandler == null) {
                throw new IllegalStateException("Cannot load a default policy handler.");
            }
        }
    }

    private XSSFilterRule getFilterRule(ProtectionContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (context == ProtectionContext.HTML_HTML_CONTENT) {
            return this.htmlHtmlContext;
        }
        return this.plainHtmlContext;
    }

    public boolean check(ProtectionContext context, String src, String policy) {
        XSSFilterRule ctx = this.getFilterRule(context);
        PolicyHandler handler = null;
        if (ctx.supportsPolicy() && (policy == null || (handler = this.policies.get(policy)) == null)) {
            handler = this.defaultHandler;
        }
        return ctx.check(handler, src);
    }

    public String filter(ProtectionContext context, String src, String policy) {
        if (src == null) {
            return "";
        }
        XSSFilterRule ctx = this.getFilterRule(context);
        PolicyHandler handler = null;
        if (ctx.supportsPolicy() && (policy == null || (handler = this.policies.get(policy)) == null)) {
            handler = this.defaultHandler;
        }
        return ctx.filter(handler, src);
    }

    public void setDefaultPolicy(InputStream policyStream) throws Exception {
        this.setDefaultHandler(new PolicyHandler(policyStream));
    }

    private void setDefaultHandler(PolicyHandler defaultHandler) {
        Attribute hrefAttribute;
        Tag linkTag = defaultHandler.getPolicy().getTagByLowercaseName("a");
        Attribute attribute = hrefAttribute = linkTag != null ? linkTag.getAttributeByName("href") : null;
        if (hrefAttribute == null) {
            hrefAttribute = DEFAULT_HREF_ATTRIBUTE;
        }
        this.defaultHandler = defaultHandler;
        this.hrefAttribute = hrefAttribute;
    }

    public void resetDefaultPolicy() {
        this.updateDefaultHandler();
    }

    public void loadPolicy(String policyName, InputStream policyStream) throws Exception {
        if (this.policies.size() < 128) {
            PolicyHandler policyHandler = new PolicyHandler(policyStream);
            this.policies.put(policyName, policyHandler);
        }
    }

    public void unloadPolicy(String policyName) {
        this.policies.remove(policyName);
    }

    public boolean hasPolicy(String policyName) {
        return this.policies.containsKey(policyName);
    }

    @Override
    public boolean isValidHref(String url) {
        boolean isValid = this.hrefAttribute.containsAllowedValue(url.toLowerCase());
        if (!isValid) {
            isValid = this.hrefAttribute.matchesAllowedExpression(url);
        }
        return isValid;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

