/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

final class FactoryFinder {
    private static boolean debug = false;

    private FactoryFinder() {
    }

    private static void dPrint(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class<?> providerClass;
            if (cl == null) {
                providerClass = Class.forName(className);
            } else {
                try {
                    providerClass = cl.loadClass(className);
                }
                catch (ClassNotFoundException x) {
                    if (doFallback) {
                        cl = FactoryFinder.class.getClassLoader();
                        providerClass = cl != null ? cl.loadClass(className) : Class.forName(className);
                    }
                    throw x;
                }
            }
            Object instance = providerClass.newInstance();
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + providerClass + " using ClassLoader: " + cl);
            }
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = FactoryFinder.class.getClassLoader();
        }
        if (debug) {
            FactoryFinder.dPrint("loaded from fallback value: " + fallbackClassName);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader, true);
    }

    static {
        try {
            String val = System.getProperty("jaxp.debug");
            debug = val != null && !"false".equals(val);
        }
        catch (SecurityException se) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

