/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.xml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.sling.xss.impl.xml.Category;
import org.apache.sling.xss.impl.xml.Literal;
import org.apache.sling.xss.impl.xml.Regexp;
import org.apache.sling.xss.impl.xml.Shorthand;

public class Property {
    private String name;
    private String description;
    private String defaultValue;
    @JacksonXmlElementWrapper(localName="regexp-list")
    private List<Regexp> regexpList;
    @JacksonXmlElementWrapper(localName="literal-list")
    private List<Literal> literalList;
    @JacksonXmlElementWrapper(localName="category-list")
    private List<Category> categoryList;
    @JacksonXmlElementWrapper(localName="shorthand-list")
    private List<Shorthand> shorthandList;
    private String onInvalid;

    @JsonCreator
    public Property(@JacksonXmlProperty(localName="name", isAttribute=true) String name, @JacksonXmlProperty(localName="regexp") List<Regexp> allowedRegexps, @JacksonXmlProperty(localName="literal") List<Literal> allowedValue, @JacksonXmlProperty(localName="shorthand") List<Shorthand> shortHandRefs, @JacksonXmlProperty(localName="description", isAttribute=true) String description, @JacksonXmlProperty(localName="onInvalid", isAttribute=true) String onInvalidStr, @JacksonXmlProperty(isAttribute=true, localName="default") String defaultValue) {
        this.name = name;
        this.description = Optional.ofNullable(description).orElse("");
        this.onInvalid = this.onInvalid != null && this.onInvalid.length() > 0 ? this.onInvalid : "removeAttribute";
        this.regexpList = Optional.ofNullable(allowedRegexps).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
        this.literalList = Optional.ofNullable(this.literalList).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
        this.shorthandList = Optional.ofNullable(shortHandRefs).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
        this.defaultValue = defaultValue;
    }

    public List<Category> getCategoryList() {
        return this.categoryList;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Literal> getLiteralList() {
        return this.literalList;
    }

    public String getName() {
        return this.name;
    }

    public List<Regexp> getRegexpList() {
        return this.regexpList;
    }

    public List<Shorthand> getShorthandList() {
        return this.shorthandList;
    }

    public List<String> getShorthands() {
        return this.shorthandList.stream().map(Shorthand::getName).collect(Collectors.toList());
    }

    public List<String> getLiterals() {
        return this.literalList.stream().map(Literal::getValue).collect(Collectors.toList());
    }

    public String getOnInvalid() {
        return this.onInvalid;
    }

    public List<Pattern> getRegexps() {
        return this.regexpList.stream().map(Regexp::getPattern).collect(Collectors.toList());
    }
}

