/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.xml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sling.xss.impl.xml.Attribute;

public class Tag {
    private String name;
    private String action;
    private List<Attribute> attributeList;

    @JsonCreator
    public Tag(@JacksonXmlProperty(isAttribute=true, localName="name") String name, @JacksonXmlProperty(isAttribute=true, localName="action") String action, @JacksonXmlElementWrapper(useWrapping=false) @JacksonXmlProperty(localName="attribute") List<Attribute> attributeList) {
        this.name = name.toLowerCase();
        this.attributeList = Optional.ofNullable(attributeList).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
        this.action = action.toLowerCase();
    }

    public String getAction() {
        return this.action;
    }

    public boolean isAction(String action) {
        return action.equals(this.action);
    }

    public Tag mutateAction(String action) {
        return new Tag(this.name, action, this.attributeList);
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Attribute> getAttributeMap() {
        return this.attributeList.stream().collect(Collectors.toMap(Attribute::getName, Function.identity()));
    }

    public Attribute getAttributeByName(String name) {
        Map<String, Attribute> attributeMap = this.getAttributeMap();
        return attributeMap.get(name);
    }
}

