/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.deploy.method;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.deploy.DeployMethod;

public class FelixPostDeployMethod
implements DeployMethod {
    @Override
    public void deploy(String targetURL, File file, String bundleSymbolicName, DeployContext context) throws MojoExecutionException {
        PostMethod filePost = new PostMethod(targetURL + "/install");
        try {
            filePost.setRequestHeader("referer", "about:blank");
            ArrayList<Object> partList = new ArrayList<Object>();
            partList.add(new StringPart("action", "install"));
            partList.add(new StringPart("_noredir_", "_noredir_"));
            partList.add(new FilePart("bundlefile", (PartSource)new FilePartSource(file.getName(), file)));
            partList.add(new StringPart("bundlestartlevel", context.getBundleStartLevel()));
            if (context.isBundleStart()) {
                partList.add(new StringPart("bundlestart", "start"));
            }
            if (context.isRefreshPackages()) {
                partList.add(new StringPart("refreshPackages", "true"));
            }
            Part[] parts = partList.toArray(new Part[partList.size()]);
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            int status = context.getHttpClient().executeMethod((HttpMethod)filePost);
            if (status == 200) {
                context.getLog().info((CharSequence)"Bundle installed");
            } else {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (context.isFailOnError()) {
                    throw new MojoExecutionException(msg);
                }
                context.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    @Override
    public void undeploy(String targetURL, File file, String bundleSymbolicName, DeployContext context) throws MojoExecutionException {
        PostMethod post = new PostMethod(targetURL + "/bundles/" + bundleSymbolicName);
        post.addParameter("action", "uninstall");
        try {
            int status = context.getHttpClient().executeMethod((HttpMethod)post);
            if (status == 200) {
                context.getLog().info((CharSequence)"Bundle uninstalled");
            } else {
                context.getLog().error((CharSequence)("Uninstall failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Uninstall from " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            post.releaseConnection();
        }
    }
}

