/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.sling.maven.bundlesupport.AbstractFsMountMojo;
import org.apache.sling.maven.bundlesupport.BundlePrerequisite;
import org.apache.sling.maven.bundlesupport.JsonSupport;
import org.apache.sling.maven.bundlesupport.deploy.BundleDeploymentMethod;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.fsresource.FileVaultXmlMounter;
import org.apache.sling.maven.bundlesupport.fsresource.SlingInitialContentMounter;

@Mojo(name="fsmount", requiresProject=true)
public class FsMountMojo
extends AbstractFsMountMojo {
    private static final String BUNDLE_GROUP_ID = "org.apache.sling";
    private static final String FS_BUNDLE_ARTIFACT_ID = "org.apache.sling.fsresource";
    private static final String FS_BUNDLE_DEFAULT_VERSION = "2.1.16";
    private static final String FS_BUNDLE_LEGACY_DEFAULT_VERSION = "1.4.8";
    private static final String RESOURCE_RESOLVER_BUNDLE_ARTIFACT_ID = "org.apache.sling.resourceresolver";
    private static final String RESOURCE_RESOLVER_BUNDLE_MIN_VERSION = "1.5.18";
    private static final String JOHNZON_BUNDLE_ARTIFACT_ID = "org.apache.sling.commons.johnzon";
    private static final String JOHNZON_BUNDLE_MIN_VERSION = "1.0.0";
    private static final String COMMONS_COLLECTIONS4_BUNDLE_GROUP_ID = "org.apache.commons";
    private static final String COMMONS_COLLECTIONS4_BUNDLE_ARTIFACT_ID = "commons-collections4";
    private static final String COMMONS_COLLECTIONS4_BUNDLE_MIN_VERSION = "4.1";
    private static final String COMMONS_COLLECTIONS4_BUNDLE_SYMBOLICNAME = "org.apache.commons.collections4";
    @Parameter(property="sling.deploy.method", required=false, defaultValue="WebConsole")
    private BundleDeploymentMethod deploymentMethod;
    @Parameter(required=false, defaultValue="true")
    private boolean deployFsResourceBundle;
    @Parameter(required=false)
    private List<BundlePrerequisite> deployFsResourceBundlePrerequisites;
    @Component
    private RepositorySystem repository;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;

    public void addDeployFsResourceBundlePrerequisite(BundlePrerequisite item) {
        if (this.deployFsResourceBundlePrerequisites == null) {
            this.deployFsResourceBundlePrerequisites = new ArrayList<BundlePrerequisite>();
        }
        this.deployFsResourceBundlePrerequisites.add(item);
    }

    @Override
    protected void configureSlingInitialContent(String targetUrl, File bundleFile) throws MojoExecutionException {
        new SlingInitialContentMounter(this.getLog(), this.getHttpClient(), this.project).mount(targetUrl, bundleFile);
    }

    @Override
    protected void configureFileVaultXml(String targetUrl, File jcrRootFile, File filterXmlFile) throws MojoExecutionException {
        new FileVaultXmlMounter(this.getLog(), this.getHttpClient(), this.project).mount(targetUrl, jcrRootFile, filterXmlFile);
    }

    @Override
    protected void ensureBundlesInstalled(String targetUrl) throws MojoExecutionException {
        if (!this.deployFsResourceBundle) {
            return;
        }
        if (this.deployFsResourceBundlePrerequisites == null) {
            BundlePrerequisite latest = new BundlePrerequisite();
            latest.addBundle(new BundlePrerequisite.Bundle(BUNDLE_GROUP_ID, JOHNZON_BUNDLE_ARTIFACT_ID, JOHNZON_BUNDLE_MIN_VERSION));
            latest.addBundle(new BundlePrerequisite.Bundle(COMMONS_COLLECTIONS4_BUNDLE_GROUP_ID, COMMONS_COLLECTIONS4_BUNDLE_ARTIFACT_ID, COMMONS_COLLECTIONS4_BUNDLE_MIN_VERSION, COMMONS_COLLECTIONS4_BUNDLE_SYMBOLICNAME));
            latest.addBundle(new BundlePrerequisite.Bundle(BUNDLE_GROUP_ID, FS_BUNDLE_ARTIFACT_ID, FS_BUNDLE_DEFAULT_VERSION));
            latest.addPrecondition(new BundlePrerequisite.Bundle(BUNDLE_GROUP_ID, RESOURCE_RESOLVER_BUNDLE_ARTIFACT_ID, RESOURCE_RESOLVER_BUNDLE_MIN_VERSION));
            this.addDeployFsResourceBundlePrerequisite(latest);
            BundlePrerequisite legacy = new BundlePrerequisite();
            legacy.addBundle(new BundlePrerequisite.Bundle(BUNDLE_GROUP_ID, FS_BUNDLE_ARTIFACT_ID, FS_BUNDLE_LEGACY_DEFAULT_VERSION));
            this.addDeployFsResourceBundlePrerequisite(legacy);
        }
        for (BundlePrerequisite bundlePrerequisite : this.deployFsResourceBundlePrerequisites) {
            if (!this.isBundlePrerequisitesPreconditionsMet(bundlePrerequisite, targetUrl)) continue;
            for (BundlePrerequisite.Bundle bundle : bundlePrerequisite.getBundles()) {
                this.deployBundle(bundle, targetUrl);
            }
        }
    }

    private void deployBundle(BundlePrerequisite.Bundle bundle, String targetUrl) throws MojoExecutionException {
        if (this.isBundleInstalled(bundle, targetUrl)) {
            this.getLog().debug((CharSequence)("Bundle " + bundle.getSymbolicName() + " " + bundle.getOsgiVersion() + " (or higher) already installed."));
            return;
        }
        this.getLog().info((CharSequence)("Installing Bundle " + bundle.getSymbolicName() + " " + bundle.getOsgiVersion() + " to " + targetUrl + " via " + (Object)((Object)this.deploymentMethod)));
        File file = this.getArtifactFile(bundle, "jar");
        this.deploymentMethod.execute().deploy(targetUrl, file, bundle.getSymbolicName(), new DeployContext().log(this.getLog()).httpClient(this.getHttpClient()).failOnError(this.failOnError));
    }

    private boolean isBundlePrerequisitesPreconditionsMet(BundlePrerequisite bundlePrerequisite, String targetUrl) throws MojoExecutionException {
        for (BundlePrerequisite.Bundle precondition : bundlePrerequisite.getPreconditions()) {
            if (this.isBundleInstalled(precondition, targetUrl)) continue;
            this.getLog().debug((CharSequence)("Bundle " + precondition.getSymbolicName() + " " + precondition.getOsgiVersion() + " (or higher) is not installed."));
            return false;
        }
        return true;
    }

    private boolean isBundleInstalled(BundlePrerequisite.Bundle bundle, String targetUrl) throws MojoExecutionException {
        String installedVersionString = this.getBundleInstalledVersion(bundle.getSymbolicName(), targetUrl);
        if (StringUtils.isBlank((CharSequence)installedVersionString)) {
            return false;
        }
        DefaultArtifactVersion installedVersion = new DefaultArtifactVersion(installedVersionString);
        DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(bundle.getOsgiVersion());
        return installedVersion.compareTo((ArtifactVersion)requiredVersion) >= 0;
    }

    private String getBundleInstalledVersion(String bundleSymbolicName, String targetUrl) throws MojoExecutionException {
        block22: {
            String getUrl = targetUrl + "/bundles/" + bundleSymbolicName + ".json";
            GetMethod get = new GetMethod(getUrl);
            try {
                String jsonText;
                int status = this.getHttpClient().executeMethod((HttpMethod)get);
                if (status != 200) break block22;
                try (InputStream jsonResponse = get.getResponseBodyAsStream();){
                    jsonText = IOUtils.toString((InputStream)jsonResponse, (Charset)StandardCharsets.UTF_8);
                }
                try {
                    JsonObject response = JsonSupport.parseObject(jsonText);
                    JsonArray data = response.getJsonArray("data");
                    if (data.size() > 0) {
                        JsonObject bundleData = data.getJsonObject(0);
                        String string = bundleData.getString("version");
                        return string;
                    }
                }
                catch (JsonException ex) {
                    throw new MojoExecutionException("Reading bundle data from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
                }
            }
            catch (HttpException ex) {
                throw new MojoExecutionException("Reading bundle data from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Reading bundle data from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
            }
            finally {
                get.releaseConnection();
            }
        }
        return null;
    }

    private File getArtifactFile(BundlePrerequisite.Bundle bundle, String type) throws MojoExecutionException {
        Artifact artifactObject = this.repository.createArtifact(bundle.getGroupId(), bundle.getArtifactId(), bundle.getVersion(), type);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifactObject);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.remoteRepositories);
        ArtifactResolutionResult result = this.repository.resolve(request);
        if (result.isSuccess()) {
            return artifactObject.getFile();
        }
        throw new MojoExecutionException("Unable to download artifact: " + artifactObject.toString());
    }
}

