/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.JsonSupport;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="validate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ValidationMojo
extends AbstractMojo {
    private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("lineNumber=(\\d+),");
    private static final Pattern COLUMN_NUMBER_PATTERN = Pattern.compile("columnNumber=(\\d+),");
    private static final Pattern MESSAGE_CLEANUP_PATTERN = Pattern.compile("^(.*) on \\[lineNumber=\\d+, columnNumber=\\d+, streamOffset=\\d+\\](.*)$", 32);
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="sling.validation.skip", defaultValue="false", required=true)
    private boolean skip;
    @Parameter(property="sling.validation.skipJson", defaultValue="false", required=true)
    private boolean skipJson;
    @Parameter(property="sling.validation.jsonQuoteTick", defaultValue="false", required=false)
    private boolean jsonQuoteTick;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Validation is skipped.");
            return;
        }
        for (Resource rsrc : this.project.getResources()) {
            File directory = new File(rsrc.getDirectory());
            if (!directory.exists()) continue;
            if (!this.buildContext.hasDelta(directory)) {
                this.getLog().debug((CharSequence)"No files found to validate, skipping.");
                return;
            }
            this.getLog().debug((CharSequence)("Scanning " + rsrc.getDirectory()));
            Scanner scanner = this.buildContext.newScanner(directory);
            if (rsrc.getExcludes() != null && rsrc.getExcludes().size() > 0) {
                scanner.setExcludes(rsrc.getExcludes().toArray(new String[rsrc.getExcludes().size()]));
            }
            scanner.addDefaultExcludes();
            if (rsrc.getIncludes() != null && rsrc.getIncludes().size() > 0) {
                scanner.setIncludes(rsrc.getIncludes().toArray(new String[rsrc.getIncludes().size()]));
            }
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            int countProcessed = 0;
            ArrayList<Exception> failures = new ArrayList<Exception>();
            if (files != null) {
                for (int m = 0; m < files.length; ++m) {
                    File file = new File(directory, files[m]);
                    this.buildContext.removeMessages(file);
                    try {
                        this.validate(file);
                    }
                    catch (Exception ex) {
                        failures.add(ex);
                        this.buildContext.addMessage(file, ValidationMojo.parseLineNumber(ex.getMessage()), ValidationMojo.parseColumnNumber(ex.getMessage()), ValidationMojo.cleanupMessage(ex.getMessage()), 2, ex.getCause());
                    }
                    ++countProcessed;
                }
            }
            if (!failures.isEmpty()) {
                if (this.buildContext.isIncremental()) continue;
                throw new MojoFailureException("Validated " + countProcessed + " file(s), found " + failures.size() + " failures.");
            }
            this.getLog().info((CharSequence)("Validated " + countProcessed + " file(s)."));
        }
    }

    private void validate(File file) throws MojoExecutionException {
        block6: {
            this.getLog().debug((CharSequence)("Validating " + file.getPath()));
            if (!file.isFile() || !file.getName().endsWith(".json") || this.skipJson) break block6;
            this.getLog().debug((CharSequence)("Validation JSON file " + file.getPath()));
            FileInputStream fis = null;
            String json = null;
            try {
                fis = new FileInputStream(file);
                json = IOUtils.toString((InputStream)fis, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                try {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            try {
                JsonSupport.validateJsonStructure(json, this.jsonQuoteTick);
            }
            catch (JsonException ex) {
                throw new MojoExecutionException("Invalid JSON: " + ex.getMessage());
            }
        }
    }

    static int parseLineNumber(String message) {
        return ValidationMojo.parseNumber(message, LINE_NUMBER_PATTERN);
    }

    static int parseColumnNumber(String message) {
        return ValidationMojo.parseNumber(message, COLUMN_NUMBER_PATTERN);
    }

    static int parseNumber(String message, Pattern pattern) {
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            return NumberUtils.toInt((String)matcher.group(1));
        }
        return 0;
    }

    static String cleanupMessage(String message) {
        Matcher matcher = MESSAGE_CLEANUP_PATTERN.matcher(message);
        String result = matcher.matches() ? matcher.group(1) + matcher.group(2) : message;
        result = StringUtils.replace((String)result, (String)"\n", (String)"\\n");
        result = StringUtils.replace((String)result, (String)"\r", (String)"");
        return result;
    }
}

