/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.deploy.method;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.deploy.DeployMethod;
import org.apache.sling.maven.bundlesupport.deploy.method.IntermediateUrisExtractor;
import org.apache.sling.maven.bundlesupport.deploy.method.MkColMethod;

public class WebDavPutDeployMethod
implements DeployMethod {
    @Override
    public void deploy(String targetURL, File file, String bundleSymbolicName, DeployContext context) throws MojoExecutionException {
        boolean success = false;
        try {
            int status = this.performPut(targetURL, file, context);
            if (status >= 200 && status < 300) {
                success = true;
            } else if (status == 409) {
                context.getLog().debug((CharSequence)"Bundle not installed due missing parent folders. Attempting to create parent structure.");
                this.createIntermediaryPaths(targetURL, context);
                context.getLog().debug((CharSequence)"Re-attempting bundle install after creating parent folders.");
                status = this.performPut(targetURL, file, context);
                if (status >= 200 && status < 300) {
                    success = true;
                }
            }
            if (!success) {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (context.isFailOnError()) {
                    throw new MojoExecutionException(msg);
                }
                context.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void undeploy(String targetURL, File file, String bundleSymbolicName, DeployContext context) throws MojoExecutionException {
        DeleteMethod delete = new DeleteMethod(this.getURLWithFilename(targetURL, file.getName()));
        try {
            int status = context.getHttpClient().executeMethod((HttpMethod)delete);
            if (status >= 200 && status < 300) {
                context.getLog().info((CharSequence)"Bundle uninstalled");
            } else {
                context.getLog().error((CharSequence)("Uninstall failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Uninstall from " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            delete.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performPut(String targetURL, File file, DeployContext context) throws HttpException, IOException {
        PutMethod filePut = new PutMethod(this.getURLWithFilename(targetURL, file.getName()));
        try {
            filePut.setRequestEntity((RequestEntity)new FileRequestEntity(file, context.getMimeType()));
            int n = context.getHttpClient().executeMethod((HttpMethod)filePut);
            return n;
        }
        finally {
            filePut.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performHead(String uri, DeployContext context) throws HttpException, IOException {
        HeadMethod head = new HeadMethod(uri);
        try {
            int n = context.getHttpClient().executeMethod((HttpMethod)head);
            return n;
        }
        finally {
            head.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performMkCol(String uri, DeployContext context) throws IOException {
        MkColMethod mkCol = new MkColMethod(uri);
        try {
            int n = context.getHttpClient().executeMethod((HttpMethod)mkCol);
            return n;
        }
        finally {
            mkCol.releaseConnection();
        }
    }

    private void createIntermediaryPaths(String targetURL, DeployContext context) throws HttpException, IOException, MojoExecutionException {
        List<String> intermediateUris = IntermediateUrisExtractor.extractIntermediateUris(targetURL);
        String existingIntermediateUri = null;
        for (String intermediateUri : intermediateUris) {
            int result = this.performHead(intermediateUri, context);
            if (result == 200 || result == 403) {
                existingIntermediateUri = intermediateUri;
                break;
            }
            if (result == 404) continue;
            throw new MojoExecutionException("Failed getting intermediate path at " + intermediateUri + ". Reason: " + HttpStatus.getStatusText((int)result));
        }
        if (existingIntermediateUri == null) {
            throw new MojoExecutionException("Could not find any intermediate path up until the root of " + targetURL + ".");
        }
        int startOfInexistingIntermediateUri = intermediateUris.indexOf(existingIntermediateUri);
        if (startOfInexistingIntermediateUri == -1) {
            throw new IllegalStateException("Could not find intermediate uri " + existingIntermediateUri + " in the list");
        }
        for (int index = startOfInexistingIntermediateUri - 1; index >= 0; --index) {
            String intermediateUri = intermediateUris.get(index);
            int result = this.performMkCol(intermediateUri, context);
            if (result != 201 && result != 200) {
                throw new MojoExecutionException("Failed creating intermediate path at '" + intermediateUri + "'. Reason: " + HttpStatus.getStatusText((int)result));
            }
            context.getLog().debug((CharSequence)("Intermediate path at " + intermediateUri + " successfully created"));
        }
    }

    private String getURLWithFilename(String targetURL, String fileName) {
        return targetURL + (targetURL.endsWith("/") ? "" : "/") + fileName;
    }
}

