/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.fsresource;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.JsonSupport;
import org.apache.sling.maven.bundlesupport.deploy.method.ResponseCodeEnforcingResponseHandler;
import org.apache.sling.maven.bundlesupport.fsresource.FsResourceConfiguration;

final class FsMountHelper {
    private static final String FS_FACTORY = "org.apache.sling.fsprovider.internal.FsResourceProvider";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String PROPERTY_FSMODE = "provider.fs.mode";
    private static final String PROPERTY_ROOT = "provider.root";
    private static final String PROPERTY_ROOTS = "provider.roots";
    private static final String PROPERTY_PATH = "provider.file";
    private static final String PROPERTY_INITIAL_CONTENT_IMPORT_OPTIONS = "provider.initial.content.import.options";
    private static final String PROPERTY_FILEVAULT_FILTER_XML = "provider.filevault.filterxml.path";
    private final Log log;
    private final CloseableHttpClient httpClient;
    private final RequestConfig.Builder requestConfigBuilder;
    private final MavenProject project;

    public FsMountHelper(Log log, CloseableHttpClient httpClient, RequestConfig.Builder requestConfigBuilder, MavenProject project) {
        this.log = log;
        this.httpClient = httpClient;
        this.requestConfigBuilder = requestConfigBuilder;
        this.project = project;
    }

    public void addConfigurations(URI targetUrl, Collection<FsResourceConfiguration> cfgs) throws MojoExecutionException {
        Map<String, FsResourceConfiguration> oldConfigs = this.getCurrentConfigurations(targetUrl);
        for (FsResourceConfiguration cfg : cfgs) {
            this.log.debug((CharSequence)("Found mapping " + cfg.getFsRootPath() + " to " + cfg.getResourceRootPath()));
            boolean found = false;
            Iterator<Map.Entry<String, FsResourceConfiguration>> entryIterator = oldConfigs.entrySet().iterator();
            while (!found && entryIterator.hasNext()) {
                Map.Entry<String, FsResourceConfiguration> current = entryIterator.next();
                FsResourceConfiguration oldcfg = current.getValue();
                this.log.debug((CharSequence)("Comparing " + oldcfg.getFsRootPath() + " with " + oldcfg));
                if (!Objects.equals(oldcfg.getFsRootPath(), cfg.getFsRootPath())) continue;
                if (cfg.equals(oldcfg)) {
                    this.log.info((CharSequence)("Using existing configuration for " + cfg.getFsRootPath() + " mounted at " + cfg.getResourceRootPath()));
                    found = true;
                } else {
                    this.log.info((CharSequence)("Removing old configuration for " + oldcfg));
                    this.removeConfiguration(targetUrl, current.getKey());
                }
                entryIterator.remove();
            }
            if (found) continue;
            this.log.debug((CharSequence)("Adding new configuration for " + cfg.getFsRootPath() + " mounted at " + cfg.getResourceRootPath()));
            this.addConfiguration(targetUrl, cfg);
            this.log.info((CharSequence)("Added new configuration for resource path " + cfg.getResourceRootPath() + " to server"));
        }
        this.removeConfigurations(targetUrl, oldConfigs);
    }

    private void addConfiguration(URI consoleTargetUrl, FsResourceConfiguration cfg) throws MojoExecutionException {
        URI postUrl = consoleTargetUrl.resolve("configMgr/org.apache.sling.fsprovider.internal.FsResourceProvider");
        HttpPost post = new HttpPost(postUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("apply", "true"));
        params.add(new BasicNameValuePair("factoryPid", FS_FACTORY));
        params.add(new BasicNameValuePair("pid", "[Temporary PID replaced by real PID upon save]"));
        Map<String, String> props = this.toMap(cfg);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        params.add(new BasicNameValuePair("propertylist", StringUtils.join(props.keySet(), (String)",")));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        RequestConfig requestConfig = this.requestConfigBuilder.setRedirectsEnabled(false).build();
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(requestConfig);
        try {
            this.httpClient.execute((ClassicHttpRequest)post, (HttpContext)httpContext, (HttpClientResponseHandler)new ResponseCodeEnforcingResponseHandler(302));
            this.log.debug((CharSequence)("New configuration created POST to " + postUrl));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Configuration on " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
        }
    }

    private Map<String, String> toMap(FsResourceConfiguration cfg) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (cfg.getFsMode() != null) {
            props.put(PROPERTY_FSMODE, cfg.getFsMode().name());
        }
        if (cfg.getFsRootPath() != null) {
            props.put(PROPERTY_PATH, cfg.getFsRootPath().toString());
        }
        if (cfg.getResourceRootPath() != null) {
            props.put(PROPERTY_ROOT, cfg.getResourceRootPath());
            props.put(PROPERTY_ROOTS, cfg.getResourceRootPath());
        }
        if (cfg.getInitialContentImportOptions() != null) {
            props.put(PROPERTY_INITIAL_CONTENT_IMPORT_OPTIONS, cfg.getInitialContentImportOptions());
        }
        if (cfg.getStringVaultFilterXml() != null) {
            props.put(PROPERTY_FILEVAULT_FILTER_XML, cfg.getStringVaultFilterXml());
        }
        return props;
    }

    public void removeConfigurations(URI targetUrl, Map<String, FsResourceConfiguration> configs) throws MojoExecutionException {
        for (Map.Entry<String, FsResourceConfiguration> current : configs.entrySet()) {
            this.log.debug((CharSequence)("Removing configuration for " + current.getValue()));
            this.removeConfiguration(targetUrl, current.getKey());
            this.log.info((CharSequence)("Removed configuration for resource path " + current.getValue().getResourceRootPath() + " (PID: " + current.getKey() + ") from server"));
        }
    }

    private void removeConfiguration(URI consoleTargetUrl, String pid) throws MojoExecutionException {
        URI postUrl = consoleTargetUrl.resolve("configMgr/" + pid);
        HttpPost post = new HttpPost(postUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("apply", "true"));
        params.add(new BasicNameValuePair("delete", "true"));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        try {
            JsonObject expectedJsonResponse = Json.createObjectBuilder().add("status", true).build();
            this.httpClient.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new ResponseCodeEnforcingResponseHandler("application/json", response -> JsonSupport.parseObject(response).equals(expectedJsonResponse), 200));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Removing configuration at " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
        }
    }

    public Map<String, FsResourceConfiguration> getCurrentConfigurations(URI consoleTargetUrl) throws MojoExecutionException {
        HashMap<String, FsResourceConfiguration> result;
        block22: {
            result = new HashMap<String, FsResourceConfiguration>();
            URI getUrl = consoleTargetUrl.resolve("configMgr/(service.factoryPid=org.apache.sling.fsprovider.internal.FsResourceProvider).json");
            this.log.debug((CharSequence)("Getting current file provider configurations via GET from " + getUrl));
            HttpGet get = new HttpGet(getUrl);
            try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)get);){
                int status = response.getCode();
                if (status == 200) {
                    String contentType = response.getHeader(HEADER_CONTENT_TYPE).getValue();
                    int pos = contentType.indexOf(59);
                    if (pos != -1) {
                        contentType = contentType.substring(0, pos);
                    }
                    if (!"application/json".equals(contentType)) {
                        this.log.debug((CharSequence)("Response type from web console is not JSON, but " + contentType));
                        throw new MojoExecutionException("The Apache Felix Web Console is too old to mount the initial content through file system provider configs. Either upgrade the web console or disable this feature.");
                    }
                    String jsonText = EntityUtils.toString((HttpEntity)response.getEntity());
                    try {
                        JsonArray array = JsonSupport.parseArray(jsonText);
                        for (int i = 0; i < array.size(); ++i) {
                            JsonObject obj = array.getJsonObject(i);
                            String pid = obj.getString("pid");
                            JsonObject properties = obj.getJsonObject("properties");
                            String fsmode = this.getConfigPropertyValue(properties, PROPERTY_FSMODE);
                            String path = this.getConfigPropertyValue(properties, PROPERTY_PATH);
                            String initialContentImportOptions = this.getConfigPropertyValue(properties, PROPERTY_INITIAL_CONTENT_IMPORT_OPTIONS);
                            String fileVaultFilterXml = this.getConfigPropertyValue(properties, PROPERTY_FILEVAULT_FILTER_XML);
                            String root = this.getConfigPropertyValue(properties, PROPERTY_ROOTS);
                            if (root == null) {
                                root = this.getConfigPropertyValue(properties, PROPERTY_ROOT);
                            }
                            if (path == null || !path.startsWith(this.project.getBasedir().getAbsolutePath()) || root == null) continue;
                            FsResourceConfiguration cfg = new FsResourceConfiguration().fsMode(fsmode).resourceRootPath(root).fsRootPath(new File(path)).initialContentImportOptions(initialContentImportOptions).fileVaultFilterXml(fileVaultFilterXml);
                            this.log.debug((CharSequence)("Found configuration with pid: " + pid + ", " + cfg));
                            result.put(pid, cfg);
                        }
                        if (array.isEmpty()) {
                            this.log.info((CharSequence)"Found no existing configurations for factory PID org.apache.sling.fsprovider.internal.FsResourceProvider");
                        }
                        break block22;
                    }
                    catch (JsonException ex) {
                        throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
                    }
                }
                throw new HttpResponseException(response.getCode(), "Unexpected status code " + response.getCode() + ": " + response.getReasonPhrase());
            }
            catch (IOException | ProtocolException ex) {
                throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
            }
        }
        return result;
    }

    private String getConfigPropertyValue(JsonObject obj, String subKey) {
        if (obj.containsKey((Object)subKey)) {
            JsonArray array;
            JsonObject subObj = obj.getJsonObject(subKey);
            if (subObj.containsKey((Object)"value")) {
                return subObj.getString("value");
            }
            if (subObj.containsKey((Object)"values") && (array = subObj.getJsonArray("values")).size() > 0) {
                return array.getString(0);
            }
        }
        return null;
    }
}

