/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.Aggregate;

@Mojo(name="aggregate-features", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AggregateFeaturesMojo
extends AbstractIncludingFeatureMojo {
    private static final String PROPERTY_HANDLED_AGGREGATE_FEATURES = AggregateFeaturesMojo.class.getName() + "/generated";
    @Parameter(required=true)
    List<Aggregate> aggregates;
    @Parameter
    Map<String, Properties> handlerConfiguration = new HashMap<String, Properties>();

    public void execute() throws MojoExecutionException {
        this.checkPreconditions();
        HashMap<Aggregate, Feature> handledAggregates = (HashMap<Aggregate, Feature>)this.project.getContextValue(PROPERTY_HANDLED_AGGREGATE_FEATURES);
        if (handledAggregates == null) {
            handledAggregates = new HashMap<Aggregate, Feature>();
            this.project.setContextValue(PROPERTY_HANDLED_AGGREGATE_FEATURES, handledAggregates);
        }
        for (Aggregate aggregate : this.aggregates) {
            String aggregateFeatureKey = ProjectHelper.generateAggregateFeatureKey(aggregate.classifier, aggregate.attach);
            Feature processedFeature = (Feature)handledAggregates.get(aggregate);
            if (processedFeature != null) {
                this.getLog().debug((CharSequence)("Found previously processed aggregate-feature " + aggregateFeatureKey));
                if (ProjectHelper.getAssembledFeatures(this.project).remove(aggregateFeatureKey, processedFeature)) {
                    this.getLog().debug((CharSequence)("  Removed previous aggregate feature '" + aggregateFeatureKey + "' from the project assembled features map"));
                }
                if (ProjectHelper.getFeatures(this.project).remove(aggregateFeatureKey, processedFeature)) {
                    this.getLog().debug((CharSequence)("  Removed previous aggregate feature '" + aggregateFeatureKey + "' from the project features map"));
                }
            }
            ProjectHelper.validateFeatureClassifiers(this.project, aggregate.classifier, aggregate.attach);
            final Map<String, Feature> selection = this.getSelectedFeatures(aggregate);
            if (selection.isEmpty()) {
                this.getLog().warn((CharSequence)("No features found for aggregate with classifier " + aggregate.classifier));
            }
            HashMap<String, String> variablesOverwrites = new HashMap<String, String>();
            if (aggregate.variablesOverrides != null) {
                variablesOverwrites.putAll(aggregate.variablesOverrides);
            }
            HashMap<String, String> frameworkPropertiesOverwrites = new HashMap<String, String>();
            if (aggregate.frameworkPropertiesOverrides != null) {
                frameworkPropertiesOverwrites.putAll(aggregate.frameworkPropertiesOverrides);
            }
            BuilderContext builderContext = new BuilderContext((FeatureProvider)new AbstractFeatureMojo.BaseFeatureProvider(){

                @Override
                public Feature provide(ArtifactId id) {
                    for (Feature feat : selection.values()) {
                        if (!feat.getId().equals((Object)id)) continue;
                        return feat;
                    }
                    return super.provide(id);
                }
            }).setArtifactProvider((ArtifactProvider)new AbstractFeatureMojo.BaseArtifactProvider()).addVariablesOverrides(variablesOverwrites).addFrameworkPropertiesOverrides(frameworkPropertiesOverwrites).addMergeExtensions((MergeHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(MergeHandler.class).iterator(), 16), false).toArray(MergeHandler[]::new)).addPostProcessExtensions((PostProcessHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(PostProcessHandler.class).iterator(), 16), false).toArray(PostProcessHandler[]::new));
            for (ArtifactId artifactId : aggregate.getArtifactOverrideRules()) {
                builderContext.addArtifactsOverride(artifactId);
            }
            builderContext.addConfigsOverrides(aggregate.getConfigurationOverrideRules());
            for (Map.Entry entry : this.handlerConfiguration.entrySet()) {
                String key = (String)entry.getKey();
                Properties props = (Properties)entry.getValue();
                builderContext.setHandlerConfiguration(key, ProjectHelper.propertiesToMap(props));
            }
            ArtifactId newFeatureID = new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), aggregate.classifier, "slingosgifeature");
            Feature feature = this.assembleFeature(newFeatureID, builderContext, selection);
            if (aggregate.markAsFinal) {
                feature.setFinal(true);
            }
            if (aggregate.markAsComplete) {
                feature.setComplete(true);
            }
            if (aggregate.title != null) {
                feature.setTitle(aggregate.title);
            }
            if (aggregate.description != null) {
                feature.setDescription(aggregate.description);
            }
            if (aggregate.vendor != null) {
                feature.setVendor(aggregate.vendor);
            }
            ProjectHelper.createTmpFeatureFile(this.project, feature);
            ProjectHelper.setFeatureInfo(this.project, feature);
            ProjectHelper.getAssembledFeatures(this.project).put(aggregateFeatureKey, feature);
            ProjectHelper.getFeatures(this.project).put(aggregateFeatureKey, feature);
            handledAggregates.put(aggregate, feature);
        }
    }

    Feature assembleFeature(ArtifactId newFeatureID, BuilderContext builderContext, Map<String, Feature> selection) throws MojoExecutionException {
        try {
            return FeatureBuilder.assemble((ArtifactId)newFeatureID, (BuilderContext)builderContext, (Feature[])selection.values().toArray(new Feature[selection.size()]));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new MojoExecutionException("Unable to aggregate feature " + (newFeatureID.getClassifier() == null ? "<main artifact>" : newFeatureID.getClassifier()) + " : " + e.getMessage(), (Exception)e);
        }
    }
}

