/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.statistics;

import com.google.common.base.Supplier;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.BytesRefFieldSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.solr.analytics.expression.ExpressionFactory;
import org.apache.solr.analytics.request.ExpressionRequest;
import org.apache.solr.analytics.statistics.DateMedianStatsCollector;
import org.apache.solr.analytics.statistics.MedianStatsCollector;
import org.apache.solr.analytics.statistics.MinMaxStatsCollector;
import org.apache.solr.analytics.statistics.NumericStatsCollector;
import org.apache.solr.analytics.statistics.PercentileStatsCollector;
import org.apache.solr.analytics.statistics.StatsCollector;
import org.apache.solr.analytics.statistics.UniqueStatsCollector;
import org.apache.solr.analytics.util.AnalyticsParams;
import org.apache.solr.analytics.util.valuesource.AbsoluteValueDoubleFunction;
import org.apache.solr.analytics.util.valuesource.AddDoubleFunction;
import org.apache.solr.analytics.util.valuesource.ConcatStringFunction;
import org.apache.solr.analytics.util.valuesource.ConstDateSource;
import org.apache.solr.analytics.util.valuesource.ConstDoubleSource;
import org.apache.solr.analytics.util.valuesource.ConstStringSource;
import org.apache.solr.analytics.util.valuesource.DateFieldSource;
import org.apache.solr.analytics.util.valuesource.DateMathFunction;
import org.apache.solr.analytics.util.valuesource.DivDoubleFunction;
import org.apache.solr.analytics.util.valuesource.DualDoubleFunction;
import org.apache.solr.analytics.util.valuesource.FilterFieldSource;
import org.apache.solr.analytics.util.valuesource.LogDoubleFunction;
import org.apache.solr.analytics.util.valuesource.MultiDateFunction;
import org.apache.solr.analytics.util.valuesource.MultiDoubleFunction;
import org.apache.solr.analytics.util.valuesource.MultiplyDoubleFunction;
import org.apache.solr.analytics.util.valuesource.NegateDoubleFunction;
import org.apache.solr.analytics.util.valuesource.PowDoubleFunction;
import org.apache.solr.analytics.util.valuesource.ReverseStringFunction;
import org.apache.solr.analytics.util.valuesource.SingleDoubleFunction;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.util.DateFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsCollectorSupplierFactory {
    private static final Logger log = LoggerFactory.getLogger(StatsCollectorSupplierFactory.class);
    static final int NUMBER_TYPE = 0;
    static final int DATE_TYPE = 1;
    static final int STRING_TYPE = 2;
    static final int FIELD_TYPE = 3;
    static final int FILTER_TYPE = 4;

    public static Supplier<StatsCollector[]> create(IndexSchema schema, List<ExpressionRequest> exRequests) {
        String[] keys;
        TreeMap<String, Set> collectorStats = new TreeMap<String, Set>();
        TreeMap<String, Set> collectorPercs = new TreeMap<String, Set>();
        TreeMap<String, ValueSource> collectorSources = new TreeMap<String, ValueSource>();
        for (ExpressionRequest expRequest : exRequests) {
            String statExpression = expRequest.getExpressionString();
            Set<String> statistics = StatsCollectorSupplierFactory.getStatistics(statExpression);
            if (statistics == null) continue;
            for (String statExp : statistics) {
                HashSet<String> stats;
                String operands;
                String stat;
                try {
                    stat = statExp.substring(0, statExp.indexOf(40)).trim();
                    operands = statExp.substring(statExp.indexOf(40) + 1, statExp.lastIndexOf(41)).trim();
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to parse statistic: [" + statExpression + "]", (Throwable)e);
                }
                String[] arguments = ExpressionFactory.getArguments(operands);
                String source = arguments[0];
                if (stat.equals("percentile")) {
                    if (arguments.length < 2) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Too few arguments given for " + stat + "() in [" + statExp + "].");
                    }
                    if (arguments.length > 2) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Too many arguments given for " + stat + "() in [" + statExp + "].");
                    }
                    source = arguments[1];
                    HashSet<Integer> percs = (HashSet<Integer>)collectorPercs.get(source);
                    if (percs == null) {
                        percs = new HashSet<Integer>();
                        collectorPercs.put(source, percs);
                    }
                    try {
                        int perc = Integer.parseInt(arguments[0]);
                        if (perc <= 0 || perc >= 100) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile in [" + statExp + "] is not between 0 and 100, exculsive.");
                        }
                        percs.add(perc);
                    }
                    catch (NumberFormatException e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "\"" + arguments[0] + "\" cannot be converted into a percentile.", (Throwable)e);
                    }
                } else {
                    if (arguments.length > 1) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Too many arguments given for " + stat + "() in [" + statExp + "].");
                    }
                    if (arguments.length == 0) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No arguments given for " + stat + "() in [" + statExp + "].");
                    }
                }
                if ((stats = (HashSet<String>)collectorStats.get(source)) == null) {
                    stats = new HashSet<String>();
                    collectorStats.put(source, stats);
                }
                if ("percentile".equals(stat)) {
                    stats.add(stat + "_" + arguments[0]);
                    continue;
                }
                stats.add(stat);
            }
        }
        for (String sourceStr : keys = collectorStats.keySet().toArray(new String[0])) {
            Set percs;
            ValueSource source = StatsCollectorSupplierFactory.buildSourceTree(schema, sourceStr);
            if (source == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The statistic [" + sourceStr + "] could not be parsed.");
            }
            String builtString = source.toString();
            collectorSources.put(builtString, source);
            if (builtString.equals(sourceStr)) continue;
            Set stats = (Set)collectorStats.remove(sourceStr);
            if (stats != null) {
                collectorStats.put(builtString, stats);
            }
            if ((percs = (Set)collectorPercs.remove(sourceStr)) != null) {
                collectorPercs.put(builtString, percs);
            }
            for (ExpressionRequest er : exRequests) {
                er.setExpressionString(er.getExpressionString().replace(sourceStr, builtString));
            }
        }
        if (collectorSources.size() == 0) {
            return new Supplier<StatsCollector[]>(){

                public StatsCollector[] get() {
                    return new StatsCollector[0];
                }
            };
        }
        log.info("Stats objects: " + collectorStats.size() + " sr=" + collectorSources.size() + " pr=" + collectorPercs.size());
        final Set[] statsArr = collectorStats.values().toArray(new Set[0]);
        final ValueSource[] sourceArr = collectorSources.values().toArray(new ValueSource[0]);
        final boolean[] uniqueBools = new boolean[statsArr.length];
        final boolean[] medianBools = new boolean[statsArr.length];
        final boolean[] numericBools = new boolean[statsArr.length];
        final boolean[] dateBools = new boolean[statsArr.length];
        final double[][] percsArr = new double[statsArr.length][];
        final String[][] percsNames = new String[statsArr.length][];
        for (int count = 0; count < sourceArr.length; ++count) {
            uniqueBools[count] = statsArr[count].contains("unique");
            medianBools[count] = statsArr[count].contains("median");
            numericBools[count] = statsArr[count].contains("sum") || statsArr[count].contains("sumofsquares") || statsArr[count].contains("mean") || statsArr[count].contains("stddev");
            dateBools[count] = sourceArr[count] instanceof DateFieldSource | sourceArr[count] instanceof MultiDateFunction | sourceArr[count] instanceof ConstDateSource;
            Set ps = (Set)collectorPercs.get(sourceArr[count].toString());
            if (ps == null) continue;
            percsArr[count] = new double[ps.size()];
            percsNames[count] = new String[ps.size()];
            int percCount = 0;
            Iterator i$ = ps.iterator();
            while (i$.hasNext()) {
                int p = (Integer)i$.next();
                percsArr[count][percCount] = (double)p / 100.0;
                percsNames[count][percCount++] = "percentile_" + p;
            }
        }
        return new Supplier<StatsCollector[]>(){

            public StatsCollector[] get() {
                StatsCollector[] collectors = new StatsCollector[statsArr.length];
                for (int count = 0; count < statsArr.length; ++count) {
                    StatsCollector sc;
                    if (numericBools[count]) {
                        sc = new NumericStatsCollector(sourceArr[count], statsArr[count]);
                        if (uniqueBools[count]) {
                            sc = new UniqueStatsCollector(sc);
                        }
                        if (medianBools[count]) {
                            sc = new MedianStatsCollector(sc);
                        }
                        if (percsArr[count] != null) {
                            sc = new PercentileStatsCollector(sc, percsArr[count], percsNames[count]);
                        }
                        collectors[count] = sc;
                        continue;
                    }
                    if (dateBools[count]) {
                        sc = new MinMaxStatsCollector(sourceArr[count], statsArr[count]);
                        if (uniqueBools[count]) {
                            sc = new UniqueStatsCollector(sc);
                        }
                        if (medianBools[count]) {
                            sc = new DateMedianStatsCollector(sc);
                        }
                        if (percsArr[count] != null) {
                            sc = new PercentileStatsCollector(sc, percsArr[count], percsNames[count]);
                        }
                        collectors[count] = sc;
                        continue;
                    }
                    sc = new MinMaxStatsCollector(sourceArr[count], statsArr[count]);
                    if (uniqueBools[count]) {
                        sc = new UniqueStatsCollector(sc);
                    }
                    if (medianBools[count]) {
                        sc = new MedianStatsCollector(sc);
                    }
                    if (percsArr[count] != null) {
                        sc = new PercentileStatsCollector(sc, percsArr[count], percsNames[count]);
                    }
                    collectors[count] = sc;
                }
                return collectors;
            }
        };
    }

    public static Set<String> getStatistics(String expression) {
        HashSet<String> set = new HashSet<String>();
        int firstParen = expression.indexOf(40);
        if (firstParen > 0) {
            String topOperation = expression.substring(0, firstParen).trim();
            if (AnalyticsParams.ALL_STAT_SET.contains(topOperation)) {
                set.add(expression);
            } else if (!(topOperation.equals("const_num") || topOperation.equals("const_date") || topOperation.equals("const_str"))) {
                String[] arguments;
                String operands = expression.substring(firstParen + 1, expression.lastIndexOf(41)).trim();
                for (String argument : arguments = ExpressionFactory.getArguments(operands)) {
                    Set<String> more = StatsCollectorSupplierFactory.getStatistics(argument);
                    if (more == null) continue;
                    set.addAll(more);
                }
            }
        }
        if (set.size() == 0) {
            return null;
        }
        return set;
    }

    private static ValueSource buildSourceTree(IndexSchema schema, String expression) {
        return StatsCollectorSupplierFactory.buildSourceTree(schema, expression, 3);
    }

    private static ValueSource buildSourceTree(IndexSchema schema, String expression, int sourceType) {
        int expressionType = StatsCollectorSupplierFactory.getSourceType(expression);
        if (sourceType != 3 && expressionType != 3 && expressionType != 4 && expressionType != sourceType) {
            return null;
        }
        switch (expressionType) {
            case 0: {
                return StatsCollectorSupplierFactory.buildNumericSource(schema, expression);
            }
            case 1: {
                return StatsCollectorSupplierFactory.buildDateSource(schema, expression);
            }
            case 2: {
                return StatsCollectorSupplierFactory.buildStringSource(schema, expression);
            }
            case 3: {
                return StatsCollectorSupplierFactory.buildFieldSource(schema, expression, sourceType);
            }
            case 4: {
                return StatsCollectorSupplierFactory.buildFilterSource(schema, expression.substring(expression.indexOf(40) + 1, expression.lastIndexOf(41)), sourceType);
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, expression + " is not a valid operation.");
    }

    private static int getSourceType(String expression) {
        int paren = expression.indexOf(40);
        if (paren < 0) {
            return 3;
        }
        String operation = expression.substring(0, paren).trim();
        if (AnalyticsParams.NUMERIC_OPERATION_SET.contains(operation)) {
            return 0;
        }
        if (AnalyticsParams.DATE_OPERATION_SET.contains(operation)) {
            return 1;
        }
        if (AnalyticsParams.STRING_OPERATION_SET.contains(operation)) {
            return 2;
        }
        if (operation.equals("filter")) {
            return 4;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The operation \"" + operation + "\" in [" + expression + "] is not supported.");
    }

    private static ValueSource buildFieldSource(IndexSchema schema, String expressionString, int sourceType) {
        SchemaField sf;
        try {
            sf = schema.getField(expressionString);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The field " + expressionString + " does not exist.", (Throwable)e);
        }
        FieldType type = sf.getType();
        if (type instanceof TrieIntField) {
            if (sourceType != 0 && sourceType != 3) {
                return null;
            }
            return new IntFieldSource(expressionString){

                public String description() {
                    return this.field;
                }
            };
        }
        if (type instanceof TrieLongField) {
            if (sourceType != 0 && sourceType != 3) {
                return null;
            }
            return new LongFieldSource(expressionString){

                public String description() {
                    return this.field;
                }
            };
        }
        if (type instanceof TrieFloatField) {
            if (sourceType != 0 && sourceType != 3) {
                return null;
            }
            return new FloatFieldSource(expressionString){

                public String description() {
                    return this.field;
                }
            };
        }
        if (type instanceof TrieDoubleField) {
            if (sourceType != 0 && sourceType != 3) {
                return null;
            }
            return new DoubleFieldSource(expressionString){

                public String description() {
                    return this.field;
                }
            };
        }
        if (type instanceof TrieDateField) {
            if (sourceType != 1 && sourceType != 3) {
                return null;
            }
            return new DateFieldSource(expressionString){

                public String description() {
                    return this.field;
                }
            };
        }
        if (type instanceof StrField) {
            if (sourceType != 2 && sourceType != 3) {
                return null;
            }
            return new BytesRefFieldSource(expressionString){

                public String description() {
                    return this.field;
                }
            };
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, type.toString() + " is not a supported field type in Solr Analytics.");
    }

    private static ValueSource buildFilterSource(IndexSchema schema, String expressionString, int sourceType) {
        Object defaultObject;
        String[] arguments = ExpressionFactory.getArguments(expressionString);
        if (arguments.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid arguments were given for \"filter\".");
        }
        ValueSource delegateSource = StatsCollectorSupplierFactory.buildSourceTree(schema, arguments[0], sourceType);
        if (delegateSource == null) {
            return null;
        }
        ValueSource src = delegateSource;
        if (delegateSource instanceof FilterFieldSource) {
            src = ((FilterFieldSource)delegateSource).getRootSource();
        }
        if (src instanceof IntFieldSource) {
            try {
                defaultObject = new Integer(arguments[1]);
            }
            catch (NumberFormatException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter value " + arguments[1] + " cannot be converted into an integer.", (Throwable)e);
            }
        } else if (src instanceof DateFieldSource || src instanceof MultiDateFunction) {
            try {
                defaultObject = DateFormatUtil.parseDate((String)arguments[1]);
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter value " + arguments[1] + " cannot be converted into a date.", (Throwable)e);
            }
        } else if (src instanceof LongFieldSource) {
            try {
                defaultObject = new Long(arguments[1]);
            }
            catch (NumberFormatException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter value " + arguments[1] + " cannot be converted into a long.", (Throwable)e);
            }
        } else if (src instanceof FloatFieldSource) {
            try {
                defaultObject = new Float(arguments[1]);
            }
            catch (NumberFormatException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter value " + arguments[1] + " cannot be converted into a float.", (Throwable)e);
            }
        } else if (src instanceof DoubleFieldSource || src instanceof SingleDoubleFunction || src instanceof DualDoubleFunction || src instanceof MultiDoubleFunction) {
            try {
                defaultObject = new Double(arguments[1]);
            }
            catch (NumberFormatException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter value " + arguments[1] + " cannot be converted into a double.", (Throwable)e);
            }
        } else {
            defaultObject = arguments[1];
        }
        return new FilterFieldSource(delegateSource, defaultObject);
    }

    private static ValueSource buildNumericSource(IndexSchema schema, String expressionString) {
        String operands;
        int paren = expressionString.indexOf(40);
        if (paren < 0) {
            return StatsCollectorSupplierFactory.buildFieldSource(schema, expressionString, 0);
        }
        try {
            operands = expressionString.substring(paren + 1, expressionString.lastIndexOf(41)).trim();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing closing parenthesis in [" + expressionString + "]");
        }
        String[] arguments = ExpressionFactory.getArguments(operands);
        String operation = expressionString.substring(0, paren).trim();
        if (operation.equals("const_num")) {
            if (arguments.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The constant number declaration [" + expressionString + "] does not have exactly 1 argument.");
            }
            return new ConstDoubleSource(Double.parseDouble(arguments[0]));
        }
        if (operation.equals("neg")) {
            if (arguments.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The negate operation [" + expressionString + "] does not have exactly 1 argument.");
            }
            ValueSource argSource = StatsCollectorSupplierFactory.buildNumericSource(schema, arguments[0]);
            if (argSource == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The operation \"neg\" requires a numeric field or operation as argument. \"" + arguments[0] + "\" is not a numeric field or operation.");
            }
            return new NegateDoubleFunction(argSource);
        }
        if (operation.equals("abs")) {
            if (arguments.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The absolute value operation [" + expressionString + "] does not have exactly 1 argument.");
            }
            ValueSource argSource = StatsCollectorSupplierFactory.buildNumericSource(schema, arguments[0]);
            if (argSource == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The operation \"neg\" requires a numeric field or operation as argument. \"" + arguments[0] + "\" is not a numeric field or operation.");
            }
            return new AbsoluteValueDoubleFunction(argSource);
        }
        if (operation.equals("filter")) {
            return StatsCollectorSupplierFactory.buildFilterSource(schema, operands, 0);
        }
        ArrayList<ValueSource> subExpressions = new ArrayList<ValueSource>();
        for (String argument : arguments) {
            ValueSource argSource = StatsCollectorSupplierFactory.buildNumericSource(schema, argument);
            if (argSource == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The operation \"" + operation + "\" requires numeric fields or operations as arguments. \"" + argument + "\" is not a numeric field or operation.");
            }
            subExpressions.add(argSource);
        }
        if (operation.equals("add")) {
            return new AddDoubleFunction(subExpressions.toArray(new ValueSource[0]));
        }
        if (operation.equals("mult")) {
            return new MultiplyDoubleFunction(subExpressions.toArray(new ValueSource[0]));
        }
        if (operation.equals("div")) {
            if (subExpressions.size() != 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The divide operation [" + expressionString + "] does not have exactly 2 arguments.");
            }
            return new DivDoubleFunction((ValueSource)subExpressions.get(0), (ValueSource)subExpressions.get(1));
        }
        if (operation.equals("pow")) {
            if (subExpressions.size() != 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The power operation [" + expressionString + "] does not have exactly 2 arguments.");
            }
            return new PowDoubleFunction((ValueSource)subExpressions.get(0), (ValueSource)subExpressions.get(1));
        }
        if (operation.equals("log")) {
            if (subExpressions.size() != 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The log operation [" + expressionString + "] does not have exactly 2 arguments.");
            }
            return new LogDoubleFunction((ValueSource)subExpressions.get(0), (ValueSource)subExpressions.get(1));
        }
        if (AnalyticsParams.DATE_OPERATION_SET.contains(operation) || AnalyticsParams.STRING_OPERATION_SET.contains(operation)) {
            return null;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The operation [" + expressionString + "] is not supported.");
    }

    private static ValueSource buildDateSource(IndexSchema schema, String expressionString) {
        int paren = expressionString.indexOf(40);
        if (paren < 0) {
            return StatsCollectorSupplierFactory.buildFieldSource(schema, expressionString, 1);
        }
        String[] arguments = ExpressionFactory.getArguments(expressionString.substring(paren + 1, expressionString.lastIndexOf(41)).trim());
        String operands = arguments[0];
        String operation = expressionString.substring(0, paren).trim();
        if (operation.equals("const_date")) {
            if (arguments.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The constant date declaration [" + expressionString + "] does not have exactly 1 argument.");
            }
            try {
                return new ConstDateSource(DateFormatUtil.parseDate((String)operands));
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The constant " + operands + " cannot be converted into a date.", (Throwable)e);
            }
        }
        if (operation.equals("filter")) {
            return StatsCollectorSupplierFactory.buildFilterSource(schema, operands, 1);
        }
        if (operation.equals("date_math")) {
            ArrayList<ValueSource> subExpressions = new ArrayList<ValueSource>();
            boolean first = true;
            for (String argument : arguments) {
                ValueSource argSource;
                if (first) {
                    first = false;
                    argSource = StatsCollectorSupplierFactory.buildDateSource(schema, argument);
                    if (argSource == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "\"date_math\" requires the first argument be a date operation or field. [" + argument + "] is not a date operation or field.");
                    }
                } else {
                    argSource = StatsCollectorSupplierFactory.buildStringSource(schema, argument);
                    if (argSource == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "\"date_math\" requires that all arguments except the first be string operations. [" + argument + "] is not a string operation.");
                    }
                }
                subExpressions.add(argSource);
            }
            return new DateMathFunction(subExpressions.toArray(new ValueSource[0]));
        }
        if (AnalyticsParams.NUMERIC_OPERATION_SET.contains(operation) || AnalyticsParams.STRING_OPERATION_SET.contains(operation)) {
            return null;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The operation [" + expressionString + "] is not supported.");
    }

    private static ValueSource buildStringSource(IndexSchema schema, String expressionString) {
        int paren = expressionString.indexOf(40);
        if (paren < 0) {
            return StatsCollectorSupplierFactory.buildFieldSource(schema, expressionString, 3);
        }
        String[] arguments = ExpressionFactory.getArguments(expressionString.substring(paren + 1, expressionString.lastIndexOf(41)).trim());
        String operands = arguments[0];
        String operation = expressionString.substring(0, paren).trim();
        if (operation.equals("const_str")) {
            operands = expressionString.substring(paren + 1, expressionString.lastIndexOf(41));
            return new ConstStringSource(operands);
        }
        if (operation.equals("filter")) {
            return StatsCollectorSupplierFactory.buildFilterSource(schema, operands, 3);
        }
        if (operation.equals("rev")) {
            if (arguments.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "\"rev\" requires exactly one argument. The number of arguments in " + expressionString + " is not 1.");
            }
            return new ReverseStringFunction(StatsCollectorSupplierFactory.buildStringSource(schema, operands));
        }
        ArrayList<ValueSource> subExpressions = new ArrayList<ValueSource>();
        for (String argument : arguments) {
            subExpressions.add(StatsCollectorSupplierFactory.buildSourceTree(schema, argument));
        }
        if (operation.equals("concat")) {
            return new ConcatStringFunction(subExpressions.toArray(new ValueSource[0]));
        }
        if (AnalyticsParams.NUMERIC_OPERATION_SET.contains(operation)) {
            return StatsCollectorSupplierFactory.buildNumericSource(schema, expressionString);
        }
        if (AnalyticsParams.DATE_OPERATION_SET.contains(operation)) {
            return StatsCollectorSupplierFactory.buildDateSource(schema, expressionString);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The operation [" + expressionString + "] is not supported.");
    }
}

