/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.accumulator;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.solr.analytics.accumulator.BasicAccumulator;
import org.apache.solr.analytics.accumulator.facet.FacetValueAccumulator;
import org.apache.solr.analytics.accumulator.facet.FieldFacetAccumulator;
import org.apache.solr.analytics.accumulator.facet.QueryFacetAccumulator;
import org.apache.solr.analytics.accumulator.facet.RangeFacetAccumulator;
import org.apache.solr.analytics.expression.Expression;
import org.apache.solr.analytics.expression.ExpressionFactory;
import org.apache.solr.analytics.request.AnalyticsRequest;
import org.apache.solr.analytics.request.FieldFacetRequest;
import org.apache.solr.analytics.request.QueryFacetRequest;
import org.apache.solr.analytics.request.RangeFacetRequest;
import org.apache.solr.analytics.statistics.StatsCollector;
import org.apache.solr.analytics.util.RangeEndpointCalculator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.Filter;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class FacetingAccumulator
extends BasicAccumulator
implements FacetValueAccumulator {
    public static final String MISSING_VALUE = "(MISSING)";
    protected boolean basicsAndFieldFacetsComputed;
    protected int leafNum;
    protected LeafReaderContext leaf;
    protected final AnalyticsRequest analyticsRequest;
    protected final Map<String, Map<String, Expression[]>> fieldFacetExpressions;
    protected final Map<String, Map<String, Expression[]>> rangeFacetExpressions;
    protected final Map<String, Map<String, Expression[]>> queryFacetExpressions;
    protected final Map<String, Map<String, StatsCollector[]>> fieldFacetCollectors;
    protected final Map<String, Map<String, StatsCollector[]>> rangeFacetCollectors;
    protected final Map<String, Map<String, StatsCollector[]>> queryFacetCollectors;
    protected final List<FieldFacetAccumulator> facetAccumulators;
    protected final Set<String> hiddenFieldFacets;
    protected final SolrQueryRequest queryRequest;
    protected List<RangeFacetRequest> rangeFacets = null;
    protected List<QueryFacetRequest> queryFacets = null;
    protected long queryCount;

    public FacetingAccumulator(SolrIndexSearcher searcher, DocSet docs, AnalyticsRequest request, SolrQueryRequest queryRequest) throws IOException {
        super(searcher, docs, request);
        this.analyticsRequest = request;
        this.queryRequest = queryRequest;
        this.basicsAndFieldFacetsComputed = false;
        List<FieldFacetRequest> fieldFreqs = request.getFieldFacets();
        List<RangeFacetRequest> rangeFreqs = request.getRangeFacets();
        List<QueryFacetRequest> queryFreqs = request.getQueryFacets();
        this.fieldFacetExpressions = new TreeMap<String, Map<String, Expression[]>>();
        this.rangeFacetExpressions = new LinkedHashMap<String, Map<String, Expression[]>>(rangeFreqs.size());
        this.queryFacetExpressions = new LinkedHashMap<String, Map<String, Expression[]>>(queryFreqs.size());
        this.fieldFacetCollectors = new LinkedHashMap<String, Map<String, StatsCollector[]>>(fieldFreqs.size());
        this.rangeFacetCollectors = new LinkedHashMap<String, Map<String, StatsCollector[]>>(rangeFreqs.size());
        this.queryFacetCollectors = new LinkedHashMap<String, Map<String, StatsCollector[]>>(queryFreqs.size());
        this.facetAccumulators = new ArrayList<FieldFacetAccumulator>();
        this.hiddenFieldFacets = new HashSet<String>();
        for (FieldFacetRequest fieldFacetRequest : fieldFreqs) {
            FieldFacetRequest fr = fieldFacetRequest;
            if (fr.isHidden()) {
                this.hiddenFieldFacets.add(fr.getName());
            }
            SchemaField ff = fr.getField();
            FieldFacetAccumulator facc = FieldFacetAccumulator.create(searcher, this, ff);
            this.facetAccumulators.add(facc);
            this.fieldFacetExpressions.put(fieldFacetRequest.getName(), new TreeMap());
            this.fieldFacetCollectors.put(fieldFacetRequest.getName(), new TreeMap());
        }
        for (RangeFacetRequest rangeFacetRequest : rangeFreqs) {
            if (this.rangeFacets == null) {
                this.rangeFacets = new ArrayList<RangeFacetRequest>();
            }
            this.rangeFacets.add(rangeFacetRequest);
            this.rangeFacetExpressions.put(rangeFacetRequest.getName(), new LinkedHashMap());
            this.rangeFacetCollectors.put(rangeFacetRequest.getName(), new LinkedHashMap());
        }
        for (QueryFacetRequest queryFacetRequest : queryFreqs) {
            if (this.queryFacets == null) {
                this.queryFacets = new ArrayList<QueryFacetRequest>();
            }
            this.queryFacets.add(queryFacetRequest);
            this.queryFacetExpressions.put(queryFacetRequest.getName(), new LinkedHashMap());
            this.queryFacetCollectors.put(queryFacetRequest.getName(), new LinkedHashMap());
        }
        this.queryCount = 0L;
    }

    public static FacetingAccumulator create(SolrIndexSearcher searcher, DocSet docs, AnalyticsRequest request, SolrQueryRequest queryRequest) throws IOException {
        return new FacetingAccumulator(searcher, docs, request, queryRequest);
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        super.doSetNextReader(context);
        for (Map<String, StatsCollector[]> valueList : this.fieldFacetCollectors.values()) {
            for (StatsCollector[] statsCollectorList : valueList.values()) {
                for (StatsCollector statsCollector : statsCollectorList) {
                    statsCollector.setNextReader(context);
                }
            }
        }
        for (FieldFacetAccumulator fa : this.facetAccumulators) {
            fa.getLeafCollector(context);
        }
    }

    @Override
    public void setRangeStatsCollectorReaders(LeafReaderContext context) throws IOException {
        super.getLeafCollector(context);
        for (Map<String, StatsCollector[]> rangeList : this.rangeFacetCollectors.values()) {
            for (StatsCollector[] statsCollectorList : rangeList.values()) {
                for (StatsCollector statsCollector : statsCollectorList) {
                    statsCollector.setNextReader(context);
                }
            }
        }
    }

    @Override
    public void setQueryStatsCollectorReaders(LeafReaderContext context) throws IOException {
        super.getLeafCollector(context);
        for (Map<String, StatsCollector[]> queryList : this.queryFacetCollectors.values()) {
            for (StatsCollector[] statsCollectorList : queryList.values()) {
                for (StatsCollector statsCollector : statsCollectorList) {
                    statsCollector.setNextReader(context);
                }
            }
        }
    }

    @Override
    public void collect(int doc) throws IOException {
        for (FieldFacetAccumulator fa : this.facetAccumulators) {
            fa.collect(doc);
        }
        super.collect(doc);
    }

    @Override
    public void collectField(int doc, String facetField, String facetValue) throws IOException {
        Map<String, StatsCollector[]> map = this.fieldFacetCollectors.get(facetField);
        StatsCollector[] statsCollectors = map.get(facetValue);
        if (statsCollectors == null) {
            statsCollectors = (StatsCollector[])this.statsCollectorArraySupplier.get();
            map.put(facetValue, statsCollectors);
            this.fieldFacetExpressions.get(facetField).put(facetValue, this.makeExpressions(statsCollectors));
            for (StatsCollector statsCollector : statsCollectors) {
                statsCollector.setNextReader(this.context);
            }
        }
        for (StatsCollector statsCollector : statsCollectors) {
            statsCollector.collect(doc);
        }
    }

    @Override
    public void collectRange(int doc, String facetField, String range) throws IOException {
        Map<String, StatsCollector[]> map = this.rangeFacetCollectors.get(facetField);
        StatsCollector[] statsCollectors = map.get(range);
        if (statsCollectors == null) {
            statsCollectors = (StatsCollector[])this.statsCollectorArraySupplier.get();
            map.put(range, statsCollectors);
            this.rangeFacetExpressions.get(facetField).put(range, this.makeExpressions(statsCollectors));
            for (StatsCollector statsCollector : statsCollectors) {
                statsCollector.setNextReader(this.context);
            }
        }
        for (StatsCollector statsCollector : statsCollectors) {
            statsCollector.collect(doc);
        }
    }

    @Override
    public void collectQuery(int doc, String facetName, String query) throws IOException {
        Map<String, StatsCollector[]> map = this.queryFacetCollectors.get(facetName);
        StatsCollector[] statsCollectors = map.get(query);
        if (statsCollectors == null) {
            statsCollectors = (StatsCollector[])this.statsCollectorArraySupplier.get();
            map.put(query, statsCollectors);
            this.queryFacetExpressions.get(facetName).put(query, this.makeExpressions(statsCollectors));
            for (StatsCollector statsCollector : statsCollectors) {
                statsCollector.setNextReader(this.context);
            }
        }
        for (StatsCollector statsCollector : statsCollectors) {
            statsCollector.collect(doc);
        }
    }

    @Override
    public void compute() {
        if (!this.basicsAndFieldFacetsComputed) {
            super.compute();
            for (Map<String, StatsCollector[]> f : this.fieldFacetCollectors.values()) {
                for (StatsCollector[] arr : f.values()) {
                    for (StatsCollector b : arr) {
                        b.compute();
                    }
                }
            }
            this.basicsAndFieldFacetsComputed = true;
        }
    }

    public void computeQueryFacet(String facet) {
        Map<String, StatsCollector[]> f = this.queryFacetCollectors.get(facet);
        for (StatsCollector[] arr : f.values()) {
            for (StatsCollector b : arr) {
                b.compute();
            }
        }
    }

    public void computeRangeFacet(String facet) {
        Map<String, StatsCollector[]> f = this.rangeFacetCollectors.get(facet);
        for (StatsCollector[] arr : f.values()) {
            for (StatsCollector b : arr) {
                b.compute();
            }
        }
    }

    public String getResult(String expressionName, String fieldFacet, String facetValue) {
        block8: {
            if (facetValue.contains("result") && !facetValue.contains("qresult")) {
                try {
                    String[] pivotStr = ExpressionFactory.getArguments(facetValue.substring(facetValue.indexOf(40) + 1, facetValue.lastIndexOf(41)).trim());
                    if (pivotStr.length == 1) {
                        facetValue = this.getResult(pivotStr[0]);
                        break block8;
                    }
                    if (pivotStr.length == 3) {
                        facetValue = this.getResult(pivotStr[0], pivotStr[1], pivotStr[2]);
                        break block8;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + facetValue + " has an invalid amount of arguments.");
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + facetValue + " is invalid. Lacks parentheses.", (Throwable)e);
                }
            }
        }
        if (this.fieldFacetExpressions.get(fieldFacet) != null) {
            Expression[] facetExpressions = this.fieldFacetExpressions.get(fieldFacet).get(facetValue);
            for (int count = 0; count < this.expressionNames.length; ++count) {
                if (!expressionName.equals(this.expressionNames[count])) continue;
                Comparable value = facetExpressions[count].getValue();
                if (value.getClass().equals(Date.class)) {
                    return ((Date)value).toInstant().toString();
                }
                return value.toString();
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field Facet Pivot expression " + expressionName + " not found.");
    }

    public String getQueryResult(String currentFacet, String expressionName, String queryFacet, String facetValue) {
        block14: {
            String[] pivotStr;
            block13: {
                if (facetValue.contains("result") && !facetValue.contains("qresult")) {
                    try {
                        pivotStr = ExpressionFactory.getArguments(facetValue.substring(facetValue.indexOf(40) + 1, facetValue.lastIndexOf(41)).trim());
                        if (pivotStr.length == 1) {
                            facetValue = this.getResult(pivotStr[0]);
                            break block13;
                        }
                        if (pivotStr.length == 3) {
                            facetValue = this.getResult(pivotStr[0], pivotStr[1], pivotStr[2]);
                            break block13;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + facetValue + " has an invalid amount of arguments.");
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + facetValue + " is invalid. Lacks parentheses.", (Throwable)e);
                    }
                }
            }
            if (facetValue.contains("qresult")) {
                try {
                    pivotStr = ExpressionFactory.getArguments(facetValue.substring(facetValue.indexOf(40) + 1, facetValue.lastIndexOf(41)).trim());
                    if (pivotStr.length == 1) {
                        facetValue = this.getResult(pivotStr[0]);
                        break block14;
                    }
                    if (pivotStr.length == 3) {
                        facetValue = this.getQueryResult(currentFacet, pivotStr[0], pivotStr[1], pivotStr[2]);
                        break block14;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + facetValue + " has an invalid amount of arguments.");
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + facetValue + " is invalid. Lacks parentheses.", (Throwable)e);
                }
            }
        }
        if (this.queryFacetExpressions.get(queryFacet) != null) {
            Expression[] facetExpressions = this.queryFacetExpressions.get(queryFacet).get(facetValue);
            for (int count = 0; count < this.expressionNames.length; ++count) {
                if (!expressionName.equals(this.expressionNames[count])) continue;
                Comparable value = facetExpressions[count].getValue();
                if (value.getClass().equals(Date.class)) {
                    return ((Date)value).toInstant().toString();
                }
                return value.toString();
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field Facet Pivot expression " + expressionName + " not found.");
    }

    @Override
    public NamedList<?> export() {
        Iterable<Map.Entry<String, Object>> iter;
        NamedList bucketBase;
        Map<String, Expression[]> buckets;
        String name;
        NamedList<?> base = super.export();
        NamedList facetList = new NamedList();
        base.add("fieldFacets", (Object)facetList);
        for (FieldFacetRequest fieldFacetRequest : this.request.getFieldFacets()) {
            name = fieldFacetRequest.getName();
            if (this.hiddenFieldFacets.contains(name)) continue;
            buckets = this.fieldFacetExpressions.get(name);
            bucketBase = new NamedList();
            iter = buckets.entrySet();
            FieldFacetRequest fr = fieldFacetRequest;
            FieldFacetRequest.FacetSortSpecification facetSortSpecification = fr.getSort();
            int limit = fr.getLimit();
            int offset = fr.getOffset();
            boolean showMissing = fr.showsMissing();
            if (!showMissing) {
                buckets.remove(MISSING_VALUE);
            }
            if (facetSortSpecification != null && buckets.values().iterator().hasNext()) {
                int sortPlace = Arrays.binarySearch(this.expressionNames, facetSortSpecification.getStatistic());
                Expression expression = buckets.values().iterator().next()[sortPlace];
                Comparator<Expression> comp = expression.comparator(facetSortSpecification.getDirection());
                ArrayList sorted = new ArrayList(buckets.size());
                Iterables.addAll(sorted, iter);
                Collections.sort(sorted, new EntryComparator(comp, sortPlace));
                iter = sorted;
            }
            if (limit > -1) {
                if (offset > 0) {
                    iter = Iterables.skip(iter, (int)offset);
                }
                iter = Iterables.limit(iter, (int)limit);
            }
            for (Map.Entry entry : iter) {
                bucketBase.add((String)entry.getKey(), this.export((Expression[])entry.getValue()));
            }
            facetList.add(name, (Object)bucketBase);
        }
        facetList = new NamedList();
        base.add("rangeFacets", (Object)facetList);
        for (RangeFacetRequest rangeFacetRequest : this.request.getRangeFacets()) {
            name = rangeFacetRequest.getName();
            buckets = this.rangeFacetExpressions.get(name);
            bucketBase = new NamedList();
            iter = buckets.entrySet();
            for (Map.Entry entry : iter) {
                bucketBase.add((String)entry.getKey(), this.export((Expression[])entry.getValue()));
            }
            facetList.add(name, (Object)bucketBase);
        }
        facetList = new NamedList();
        base.add("queryFacets", (Object)facetList);
        for (QueryFacetRequest queryFacetRequest : this.request.getQueryFacets()) {
            name = queryFacetRequest.getName();
            buckets = this.queryFacetExpressions.get(name);
            bucketBase = new NamedList();
            iter = buckets.entrySet();
            for (Map.Entry entry : iter) {
                bucketBase.add((String)entry.getKey(), this.export((Expression[])entry.getValue()));
            }
            facetList.add(name, (Object)bucketBase);
        }
        return base;
    }

    public NamedList<?> export(Expression[] expressionArr) {
        NamedList base = new NamedList();
        for (int count = 0; count < expressionArr.length; ++count) {
            if (this.hiddenExpressions.contains(this.expressionNames[count])) continue;
            base.add(this.expressionNames[count], (Object)expressionArr[count].getValue());
        }
        return base;
    }

    @Override
    public void postProcess() throws IOException {
        super.compute();
        for (Map<String, StatsCollector[]> f : this.fieldFacetCollectors.values()) {
            for (StatsCollector[] arr : f.values()) {
                for (StatsCollector b : arr) {
                    b.compute();
                }
            }
        }
        this.basicsAndFieldFacetsComputed = true;
        Filter filter = this.docs.getTopFilter();
        if (this.rangeFacets != null) {
            this.processRangeFacets(filter);
        }
        if (this.queryFacets != null) {
            this.processQueryFacets(filter);
        }
    }

    public void processQueryFacets(Filter filter) throws IOException {
        for (QueryFacetRequest qfr : this.queryFacets) {
            for (String query : qfr.getQueries()) {
                Query q;
                String[] pivotStr;
                if (query.contains("result") && !query.contains("qresult")) {
                    try {
                        pivotStr = ExpressionFactory.getArguments(query.substring(query.indexOf(40) + 1, query.lastIndexOf(41)).trim());
                        if (pivotStr.length == 1) {
                            query = this.getResult(pivotStr[0]);
                        }
                        if (pivotStr.length == 3) {
                            query = this.getResult(pivotStr[0], pivotStr[1], pivotStr[2]);
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + query + " has an invalid amount of arguments.");
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + query + " is invalid. Lacks parentheses.", (Throwable)e);
                    }
                } else if (query.contains("qresult")) {
                    try {
                        pivotStr = ExpressionFactory.getArguments(query.substring(query.indexOf(40) + 1, query.lastIndexOf(41)).trim());
                        if (pivotStr.length != 3) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + query + " has an invalid amount of arguments.");
                        }
                        query = this.getQueryResult(qfr.getName(), pivotStr[0], pivotStr[1], pivotStr[2]);
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + query + " is invalid. Lacks parentheses.", (Throwable)e);
                    }
                }
                QueryFacetAccumulator qAcc = new QueryFacetAccumulator(this, qfr.getName(), query);
                try {
                    q = QParser.getParser((String)query, null, (SolrQueryRequest)this.queryRequest).getQuery();
                }
                catch (SyntaxError e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid query '" + query + "'", (Throwable)e);
                }
                BooleanQuery filtered = new BooleanQuery.Builder().add(q, BooleanClause.Occur.MUST).add((Query)filter, BooleanClause.Occur.FILTER).build();
                this.searcher.search((Query)filtered, (Collector)qAcc);
                this.computeQueryFacet(qfr.getName());
                ++this.queryCount;
            }
        }
    }

    @Override
    public long getNumQueries() {
        return this.queryCount;
    }

    public void processRangeFacets(Filter filter) throws IOException {
        for (RangeFacetRequest rfr : this.rangeFacets) {
            String[] pivotStr;
            block25: {
                String end;
                block24: {
                    String start = rfr.getStart();
                    if (start.contains("qresult")) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Query result requests can not be used in Range Facets");
                    }
                    if (start.contains("result")) {
                        try {
                            pivotStr = ExpressionFactory.getArguments(start.substring(start.indexOf(40) + 1, start.indexOf(41)).trim());
                            if (pivotStr.length == 1) {
                                rfr.setStart(this.getResult(pivotStr[0]));
                                break block24;
                            }
                            if (pivotStr.length == 3) {
                                rfr.setStart(this.getResult(pivotStr[0], pivotStr[1], pivotStr[2]));
                                break block24;
                            }
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + start + " has an invalid amount of arguments.");
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + start + " is invalid. Lacks parentheses.", (Throwable)e);
                        }
                    }
                }
                if ((end = rfr.getEnd()).contains("qresult")) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Query result requests can not be used in Range Facets");
                }
                if (end.contains("result")) {
                    try {
                        pivotStr = ExpressionFactory.getArguments(end.substring(end.indexOf(40) + 1, end.indexOf(41)).trim());
                        if (pivotStr.length == 1) {
                            rfr.setEnd(this.getResult(pivotStr[0]));
                            break block25;
                        }
                        if (pivotStr.length == 3) {
                            rfr.setEnd(this.getResult(pivotStr[0], pivotStr[1], pivotStr[2]));
                            break block25;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + end + " has an invalid amount of arguments.");
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + end + " is invalid. Lacks parentheses.", (Throwable)e);
                    }
                }
            }
            String[] gaps = rfr.getGaps();
            for (int count = 0; count < gaps.length; ++count) {
                String gap = gaps[count];
                if (gap.contains("qresult")) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Query result requests can not be used in Range Facets");
                }
                if (!gap.contains("result")) continue;
                try {
                    pivotStr = ExpressionFactory.getArguments(gap.substring(gap.indexOf(40) + 1, gap.indexOf(41)).trim());
                    if (pivotStr.length == 1) {
                        gaps[count] = this.getResult(pivotStr[0]);
                        continue;
                    }
                    if (pivotStr.length == 3) {
                        gaps[count] = this.getResult(pivotStr[0], pivotStr[1], pivotStr[2]);
                        continue;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + gap + " has an invalid amount of arguments.");
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Result request " + gap + " is invalid. Lacks parentheses.", (Throwable)e);
                }
            }
            RangeEndpointCalculator<Comparable<?>> rec = RangeEndpointCalculator.create(rfr);
            SchemaField sf = rfr.getField();
            for (RangeEndpointCalculator.FacetRange range : rec.getRanges()) {
                String upper;
                String lower;
                String facetValue = "";
                if (range.lower == null) {
                    facetValue = "(*";
                    lower = null;
                } else {
                    lower = range.lower;
                    facetValue = (range.includeLower ? "[" : "(") + range.lower;
                }
                facetValue = facetValue + " TO ";
                if (range.upper == null) {
                    upper = null;
                    facetValue = facetValue + "*)";
                } else {
                    upper = range.upper;
                    facetValue = facetValue + range.upper + (range.includeUpper ? "]" : ")");
                }
                Query q = sf.getType().getRangeQuery(null, sf, lower, upper, range.includeLower, range.includeUpper);
                RangeFacetAccumulator rAcc = new RangeFacetAccumulator(this, rfr.getName(), facetValue);
                BooleanQuery filtered = new BooleanQuery.Builder().add(q, BooleanClause.Occur.MUST).add((Query)filter, BooleanClause.Occur.FILTER).build();
                this.searcher.search((Query)filtered, (Collector)rAcc);
                this.computeRangeFacet(sf.getName());
            }
        }
    }

    public static class EntryComparator
    implements Comparator<Map.Entry<String, Expression[]>> {
        private final Comparator<Expression> comp;
        private final int comparatorExpressionPlace;

        public EntryComparator(Comparator<Expression> comp, int comparatorExpressionPlace) {
            this.comp = comp;
            this.comparatorExpressionPlace = comparatorExpressionPlace;
        }

        @Override
        public int compare(Map.Entry<String, Expression[]> o1, Map.Entry<String, Expression[]> o2) {
            return this.comp.compare(o1.getValue()[this.comparatorExpressionPlace], o2.getValue()[this.comparatorExpressionPlace]);
        }
    }
}

