/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDate;
import org.apache.solr.analytics.util.valuesource.ConstDoubleSource;

public class ConstDateSource
extends ConstDoubleSource {
    public static final String NAME = "const_date";

    public ConstDateSource(Date constant) {
        super(constant.getTime());
    }

    public ConstDateSource(Long constant) {
        super(constant.longValue());
    }

    @Override
    public String description() {
        return this.name() + "(" + Instant.ofEpochMilli(this.getLong()) + ")";
    }

    @Override
    protected String name() {
        return NAME;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        return new FloatDocValues((ValueSource)this){

            public float floatVal(int doc) {
                return ConstDateSource.this.getFloat();
            }

            public int intVal(int doc) {
                return ConstDateSource.this.getInt();
            }

            public long longVal(int doc) {
                return ConstDateSource.this.getLong();
            }

            public double doubleVal(int doc) {
                return ConstDateSource.this.getDouble();
            }

            public String toString(int doc) {
                return ConstDateSource.this.description();
            }

            public Object objectVal(int doc) {
                return new Date(this.longVal(doc));
            }

            public String strVal(int doc) {
                return Instant.ofEpochMilli(this.longVal(doc)).toString();
            }

            public boolean boolVal(int doc) {
                return ConstDateSource.this.getFloat() != 0.0f;
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueDate mval = new MutableValueDate();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        this.mval.value = this.longVal(doc);
                        this.mval.exists = true;
                    }
                };
            }
        };
    }
}

