/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.analytics.util.valuesource.SingleDoubleFunction;

public class AbsoluteValueDoubleFunction
extends SingleDoubleFunction {
    public static final String NAME = "abs";

    public AbsoluteValueDoubleFunction(ValueSource source) {
        super(source);
    }

    @Override
    protected String name() {
        return NAME;
    }

    @Override
    public String description() {
        return this.name() + "(" + this.source.description() + ")";
    }

    @Override
    protected double func(int doc, FunctionValues vals) {
        double d = vals.doubleVal(doc);
        if (d < 0.0) {
            return d * -1.0;
        }
        return d;
    }

    @Override
    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbsoluteValueDoubleFunction other = (AbsoluteValueDoubleFunction)((Object)o);
        return this.source.equals((Object)other.source);
    }
}

