/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.IntConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.common.SolrException;

class IntStreamRemoveFunction
extends IntValueStream.AbstractIntValueStream {
    private final IntValueStream baseExpr;
    private final IntValue removeExpr;
    public static final String name = "remove";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public IntStreamRemoveFunction(IntValueStream baseExpr, IntValue removeExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.removeExpr = removeExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, removeExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
    }

    @Override
    public void streamInts(IntConsumer cons) {
        int removeValue = this.removeExpr.getInt();
        if (this.removeExpr.exists()) {
            this.baseExpr.streamInts(value -> {
                if (removeValue == value) {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamInts(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

