/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.LongConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.common.SolrException;

class LongStreamFillMissingFunction
extends LongValueStream.AbstractLongValueStream
implements LongConsumer {
    private final LongValueStream baseExpr;
    private final LongValueStream fillExpr;
    public static final String name = "fillmissing";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;
    LongConsumer cons;

    public LongStreamFillMissingFunction(LongValueStream baseExpr, LongValueStream fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        this.exists = false;
        this.cons = cons;
        this.baseExpr.streamLongs(this);
        if (!this.exists) {
            this.fillExpr.streamLongs(cons);
        }
    }

    @Override
    public void accept(long value) {
        this.exists = true;
        this.cons.accept(value);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

