/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.OrdinalFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;

class DoubleOrdinalFunction
extends DoubleValue.AbstractDoubleValue
implements ReductionFunction {
    private SortedListCollector.SortedDoubleListCollector collector;
    private int ordinal;
    public static final String name = "ordinal";
    private final String exprStr;

    public DoubleOrdinalFunction(DoubleValueStream param, int ordinal) {
        this.collector = new SortedListCollector.SortedDoubleListCollector(param);
        this.ordinal = ordinal;
        this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
    }

    @Override
    public double getDouble() {
        int size = this.collector.size();
        if (this.ordinal > 0) {
            return this.ordinal <= size ? (Double)this.collector.get(this.ordinal - 1) : 0.0;
        }
        return this.ordinal * -1 <= size ? (Double)this.collector.get(size + this.ordinal) : 0.0;
    }

    @Override
    public boolean exists() {
        return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (SortedListCollector.SortedDoubleListCollector)sync.apply(this.collector);
        if (this.ordinal > 0) {
            this.collector.calcOrdinal(this.ordinal);
        } else {
            this.collector.calcReverseOrdinal(this.ordinal * -1);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

