/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.util.function.Consumer;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.ComparableValue;
import org.apache.solr.analytics.value.StringValue;

public interface BooleanValue
extends BooleanValueStream,
AnalyticsValue {
    public boolean getBoolean();

    public static abstract class AbstractBooleanValue
    implements CastingBooleanValue {
        @Override
        public String getString() {
            boolean val = this.getBoolean();
            return this.exists() ? Boolean.toString(val) : null;
        }

        @Override
        public Object getObject() {
            boolean val = this.getBoolean();
            return this.exists() ? Boolean.valueOf(val) : null;
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            boolean val = this.getBoolean();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String val = this.getString();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            Object val = this.getObject();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public ExpressionComparator<Boolean> getObjectComparator(String expression) {
            return new ExpressionComparator<Boolean>(expression);
        }
    }

    public static interface CastingBooleanValue
    extends BooleanValue,
    StringValue,
    ComparableValue {
    }
}

