/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.CompResultFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.DoubleValue;

class CompareDoubleValueFunction
extends BooleanValue.AbstractBooleanValue {
    private final DoubleValue exprA;
    private final DoubleValue exprB;
    private final CompResultFunction comp;
    private final String name;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public CompareDoubleValueFunction(String name, DoubleValue exprA, DoubleValue exprB, CompResultFunction comp) {
        this.name = name;
        this.exprA = exprA;
        this.exprB = exprB;
        this.comp = comp;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, exprA, exprB);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, exprA, exprB);
    }

    @Override
    public boolean getBoolean() {
        double valueA = this.exprA.getDouble();
        double valueB = this.exprB.getDouble();
        this.exists = this.exprA.exists() && this.exprB.exists();
        return this.exists ? this.comp.apply(Double.compare(valueA, valueB)) : false;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

